/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jboss.logging.Logger;
import org.jboss.tm.recovery.HexDump;

public class HeuristicStatusLog {
    private static Logger errorLog = Logger.getLogger((Class)(class$org$jboss$tm$recovery$HeuristicStatusLog == null ? (class$org$jboss$tm$recovery$HeuristicStatusLog = HeuristicStatusLog.class$("org.jboss.tm.recovery.HeuristicStatusLog")) : class$org$jboss$tm$recovery$HeuristicStatusLog));
    private static boolean traceEnabled = errorLog.isTraceEnabled();
    private File logFile;
    RandomAccessFile os;
    private FileChannel channel;
    static /* synthetic */ Class class$org$jboss$tm$recovery$HeuristicStatusLog;

    HeuristicStatusLog(File dir) throws IOException {
        this.logFile = File.createTempFile("HEURISTIC_STATUS_LOG", ".log", dir);
        this.os = new RandomAccessFile(this.logFile, "rw");
        this.channel = this.os.getChannel();
        this.channel.force(true);
    }

    void write(ByteBuffer record) {
        if (traceEnabled) {
            errorLog.trace((Object)("Heuristic status log record:" + HexDump.fromBuffer(record.array())));
        }
        try {
            this.channel.write(record);
            this.channel.force(true);
        }
        catch (IOException e) {
            errorLog.error((Object)("Error writing heuristic status log " + this.logFile.getName()), (Throwable)e);
        }
    }

    void close() {
        try {
            this.os.close();
        }
        catch (IOException e) {
            errorLog.error((Object)("Error closing heuristic status log " + this.logFile.getName()), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

