/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.soap.SOAPBinding;
import javax.xml.rpc.encoding.TypeMapping;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.Style;
import org.jboss.ws.core.utils.DOMUtils;
import org.jboss.ws.core.utils.DOMWriter;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.JavaToWSDL11;
import org.jboss.ws.tools.metadata.ToolsUnifiedMetaDataBuilder;
import org.jboss.ws.tools.wsdl.WSDLWriter;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaToWSDL {
    private static final Logger log = Logger.getLogger(JavaToWSDL.class);
    private String wsdlNamespace;
    private String targetNamespace;
    private String typeNamespace;
    private String serviceName;
    private String portTypeName;
    private Style style;
    private SOAPBinding.ParameterStyle parameterStyle;
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    private Map<String, String> packageNamespaceMap = new HashMap<String, String>();
    private TypeMapping typeMapping = null;
    private JavaWsdlMapping javaWsdlMapping = null;
    private UnifiedMetaData umd = null;
    private boolean qualifiedElements = false;
    private Map<String, List<Configuration.OperationConfig>> operationMap = null;

    public JavaToWSDL(String namespace) {
        if (!"http://schemas.xmlsoap.org/wsdl/".equals(namespace)) {
            throw new IllegalArgumentException("Unsupported wsdl version: " + namespace);
        }
        this.wsdlNamespace = namespace;
    }

    public void addFeature(String name, boolean value) {
        this.features.put(name, new Boolean(value));
    }

    public boolean getFeature(String name) {
        Boolean val = this.features.get(name);
        if (val == null) {
            throw new WSException("Feature value not available: " + name);
        }
        return val;
    }

    public String getWsdlNamespace() {
        return this.wsdlNamespace;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getTypeNamespace() {
        return this.typeNamespace;
    }

    public void setTypeNamespace(String typeNamespace) {
        this.typeNamespace = typeNamespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String endpointName) {
        this.portTypeName = endpointName;
    }

    public TypeMapping getTypeMapping() {
        if (this.typeMapping == null) {
            throw new WSException("TypeMapping has not been generated");
        }
        return this.typeMapping;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public SOAPBinding.ParameterStyle getParameterStyle() {
        return this.parameterStyle;
    }

    public void setParameterStyle(SOAPBinding.ParameterStyle parameterStyle) {
        this.parameterStyle = parameterStyle;
    }

    public void setPackageNamespaceMap(Map<String, String> pn) {
        this.packageNamespaceMap = pn;
    }

    public void setOperationMap(Map<String, List<Configuration.OperationConfig>> operationMap) {
        this.operationMap = operationMap;
    }

    public void setUnifiedMetaData(UnifiedMetaData um) {
        this.umd = um;
    }

    public UnifiedMetaData getUnifiedMetaData() {
        return this.umd;
    }

    public void setUmd(UnifiedMetaData umd) {
        this.umd = umd;
    }

    public boolean isQualifiedElements() {
        return this.qualifiedElements;
    }

    public void setQualifiedElements(boolean qualifiedElements) {
        this.qualifiedElements = qualifiedElements;
    }

    public JavaWsdlMapping getJavaWsdlMapping() {
        return this.javaWsdlMapping;
    }

    public WSDLDefinitions generate(Class endpoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("generate [endpoint=" + endpoint.getName() + ",tnsURI=" + this.targetNamespace + ",service=" + this.serviceName + ",portType=" + this.portTypeName + "]"));
        }
        if (this.umd == null) {
            this.umd = new ToolsUnifiedMetaDataBuilder(endpoint, this.targetNamespace, this.typeNamespace, this.serviceName, this.style, this.parameterStyle, this.operationMap).getUnifiedMetaData();
        }
        if (this.typeNamespace != null) {
            this.packageNamespaceMap.put(endpoint.getPackage().getName(), this.typeNamespace);
        }
        WSDLDefinitions wsdlDefinitions = null;
        try {
            if ("http://schemas.xmlsoap.org/wsdl/".equals(this.wsdlNamespace)) {
                JavaToWSDL11 javaWSDL11 = new JavaToWSDL11();
                javaWSDL11.addFeatures(this.features);
                javaWSDL11.setPackageNamespaceMap(this.packageNamespaceMap);
                javaWSDL11.addFeatures(this.features);
                if (this.umd != null) {
                    javaWSDL11.setUnifiedMetaData(this.umd);
                }
                javaWSDL11.setQualifiedElements(this.qualifiedElements);
                wsdlDefinitions = javaWSDL11.generate(endpoint);
                this.typeMapping = javaWSDL11.getTypeMapping();
                this.javaWsdlMapping = javaWSDL11.getJavaWsdlMapping();
            }
            if (wsdlDefinitions == null) {
                throw new WSException("Cannot generate WSDL definitions");
            }
            StringWriter sw = new StringWriter();
            new WSDLWriter(wsdlDefinitions).write(sw, "UTF-8");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generated WSDL:\n" + sw.toString()));
            }
            String jaxrpcMappingStr = null;
            if (this.javaWsdlMapping != null) {
                Element root = DOMUtils.parse(this.javaWsdlMapping.serialize());
                jaxrpcMappingStr = DOMWriter.printNode(root, true);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generated Mapping:\n" + jaxrpcMappingStr));
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            log.error((Object)"Cannot generate WSDL", (Throwable)e);
            throw new WSException("Cannot generate wsdl from: " + endpoint);
        }
        return wsdlDefinitions;
    }
}

