/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Manager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="conversationList")
@Intercept(value=InterceptionType.NEVER)
public class ConversationList
implements Serializable {
    private List<ConversationEntry> conversationEntryList;

    @Create
    public void createConversationEntryList() {
        Map<String, ConversationEntry> map = Manager.instance().getConversationIdEntryMap();
        TreeSet<ConversationEntry> orderedEntries = new TreeSet<ConversationEntry>();
        orderedEntries.addAll(map.values());
        this.conversationEntryList = new ArrayList<ConversationEntry>(map.size());
        for (ConversationEntry entry : orderedEntries) {
            if (!entry.isDisplayable() || Seam.isSessionInvalid()) continue;
            this.conversationEntryList.add(entry);
        }
    }

    @Unwrap
    public List<ConversationEntry> getConversationEntryList() {
        return this.conversationEntryList;
    }
}

