/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.monitor;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilesystemAlterationMonitor
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jci$monitor$FilesystemAlterationMonitor == null ? (class$org$apache$commons$jci$monitor$FilesystemAlterationMonitor = FilesystemAlterationMonitor.class$("org.apache.commons.jci.monitor.FilesystemAlterationMonitor")) : class$org$apache$commons$jci$monitor$FilesystemAlterationMonitor));
    private Map listeners = new UniqueMultiHashMap();
    private Map directories = new UniqueMultiHashMap();
    private Map entries = new HashMap();
    private final Object mutexListeners = new Object();
    private final Object mutexRunning = new Object();
    private long delay = 3000L;
    private boolean running = true;
    private Thread thread;
    static /* synthetic */ Class class$org$apache$commons$jci$monitor$FilesystemAlterationMonitor;

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mutexRunning;
        synchronized (object) {
            this.running = false;
        }
        try {
            this.thread.join(this.delay);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setInterval(long pDelay) {
        this.delay = pDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FilesystemAlterationListener pListener) {
        File directory = pListener.getRepository();
        Object object = this.mutexListeners;
        synchronized (object) {
            UniqueMultiHashMap newListeners = new UniqueMultiHashMap(this.listeners);
            newListeners.put(pListener, directory);
            this.listeners = newListeners;
            UniqueMultiHashMap newDirectories = new UniqueMultiHashMap(this.directories);
            newDirectories.put(directory, pListener);
            this.directories = newDirectories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getListeners() {
        Object object = this.mutexListeners;
        synchronized (object) {
            return this.listeners.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getListenersFor(File pRepository) {
        Object object = this.mutexListeners;
        synchronized (object) {
            return (Collection)this.directories.get(pRepository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FilesystemAlterationListener listener) {
        Object object = this.mutexListeners;
        synchronized (object) {
            UniqueMultiHashMap newListeners = new UniqueMultiHashMap(this.listeners);
            Collection d = (Collection)((HashMap)((Object)newListeners)).remove(listener);
            this.listeners = newListeners;
            if (d != null) {
                UniqueMultiHashMap newDirectories = new UniqueMultiHashMap(this.directories);
                Iterator it = d.iterator();
                while (it.hasNext()) {
                    ((HashMap)((Object)newDirectories)).remove(it.next());
                    this.entries.remove(d);
                }
                this.directories = newDirectories;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStart(File root) {
        Map directories;
        log.debug((Object)("start checking " + root));
        Object object = this.mutexListeners;
        synchronized (object) {
            directories = this.directories;
        }
        Collection l = (Collection)directories.get(root);
        if (l != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                listener.onStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStop(File root) {
        Map directories;
        log.debug((Object)("stop checking " + root));
        Object object = this.mutexListeners;
        synchronized (object) {
            directories = this.directories;
        }
        Collection l = (Collection)directories.get(root);
        if (l != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                listener.onStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCreate(File root, Entry entry) {
        Map directories;
        log.debug((Object)("created " + (entry.isDirectory() ? "dir " : "file ") + entry));
        Object object = this.mutexListeners;
        synchronized (object) {
            directories = this.directories;
        }
        Collection l = (Collection)directories.get(root);
        if (l != null) {
            if (entry.isDirectory()) {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                    listener.onCreateDirectory(entry.getFile());
                }
            } else {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                    listener.onCreateFile(entry.getFile());
                }
            }
        }
        entry.markNotChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChange(File root, Entry entry) {
        Map directories;
        log.debug((Object)("changed " + (entry.isDirectory() ? "dir " : "file ") + entry));
        Object object = this.mutexListeners;
        synchronized (object) {
            directories = this.directories;
        }
        Collection l = (Collection)directories.get(root);
        if (l != null) {
            if (entry.isDirectory()) {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                    listener.onChangeDirectory(entry.getFile());
                }
            } else {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                    listener.onChangeFile(entry.getFile());
                }
            }
        }
        entry.markNotChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDelete(File root, Entry entry) {
        Map directories;
        log.debug((Object)("deleted " + (entry.isDirectory() ? "dir " : "file ") + entry));
        Object object = this.mutexListeners;
        synchronized (object) {
            directories = this.directories;
        }
        Collection l = (Collection)directories.get(root);
        if (l != null) {
            if (entry.isDirectory()) {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                    listener.onDeleteDirectory(entry.getFile());
                }
            } else {
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    FilesystemAlterationListener listener = (FilesystemAlterationListener)it.next();
                    listener.onDeleteFile(entry.getFile());
                }
            }
        }
        entry.markNotChanged();
    }

    private void check(File root, Entry entry, boolean create) {
        if (entry.isDirectory()) {
            Entry[] currentChilds = entry.getChilds();
            if (entry.hasChanged() || create) {
                Entry child;
                int i;
                if (!create) {
                    this.onChange(root, entry);
                    for (int i2 = 0; i2 < currentChilds.length; ++i2) {
                        Entry child2 = currentChilds[i2];
                        if (!child2.isDelected()) continue;
                        entry.delete(child2);
                        currentChilds[i2] = null;
                    }
                }
                Entry[] newChilds = entry.getNonChilds();
                for (i = 0; i < newChilds.length; ++i) {
                    child = newChilds[i];
                    entry.add(child);
                }
                if (!create) {
                    for (i = 0; i < currentChilds.length; ++i) {
                        child = currentChilds[i];
                        if (child == null) continue;
                        this.check(root, child, false);
                    }
                }
                for (i = 0; i < newChilds.length; ++i) {
                    child = newChilds[i];
                    this.check(root, child, true);
                }
            } else {
                for (int i = 0; i < currentChilds.length; ++i) {
                    Entry child = currentChilds[i];
                    this.check(root, child, false);
                }
            }
        } else if (entry.isDelected()) {
            this.onDelete(root, entry);
        } else if (entry.hasChanged()) {
            this.onChange(root, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        log.debug((Object)"fam running");
        while (true) {
            Map directories;
            Object object = this.mutexRunning;
            synchronized (object) {
                if (!this.running) {
                    break;
                }
            }
            Object object2 = this.mutexListeners;
            synchronized (object2) {
                directories = this.directories;
            }
            Iterator it = directories.keySet().iterator();
            while (it.hasNext()) {
                Entry root;
                File directory = (File)it.next();
                if (!directory.exists()) continue;
                this.onStart(directory);
                Object object3 = this.mutexListeners;
                synchronized (object3) {
                    root = (Entry)this.entries.get(directory);
                    if (root == null) {
                        root = new Entry(directory, directory);
                        this.entries.put(directory, root);
                    }
                }
                this.check(directory, root, false);
                this.onStop(directory);
            }
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
        log.debug((Object)"fam exiting");
    }

    public String toString() {
        return this.listeners.toString() + this.directories.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class UniqueMultiHashMap
    extends MultiHashMap {
        private static final long serialVersionUID = 1L;

        public UniqueMultiHashMap() {
        }

        public UniqueMultiHashMap(Map copy) {
            super(copy);
        }

        protected Collection createCollection(Collection copy) {
            if (copy != null) {
                return new HashSet(copy);
            }
            return new HashSet();
        }
    }

    public class Entry {
        private final File root;
        private final File file;
        private long lastModified;
        private Set paths = new HashSet();
        private Set childs = new HashSet();
        private final boolean isDirectory;

        public Entry(File pRoot, File pFile) {
            this.root = pRoot;
            this.file = pFile;
            this.lastModified = -1L;
            this.isDirectory = this.file.isDirectory();
        }

        public boolean hasChanged() {
            long modified = this.file.lastModified();
            return modified != this.lastModified;
        }

        public boolean isDelected() {
            return !this.file.exists();
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public Entry[] getChilds() {
            Entry[] r = new Entry[this.childs.size()];
            this.childs.toArray(r);
            return r;
        }

        private FileFilter getFileFilter() {
            return new FileFilter(){

                public boolean accept(File pathname) {
                    String p = pathname.getAbsolutePath();
                    return !Entry.this.paths.contains(p);
                }
            };
        }

        public Entry[] getNonChilds() {
            File[] newFiles = this.file.listFiles(this.getFileFilter());
            Entry[] r = new Entry[newFiles.length];
            for (int i = 0; i < newFiles.length; ++i) {
                r[i] = new Entry(this.root, newFiles[i]);
            }
            return r;
        }

        public void add(Entry entry) {
            this.childs.add(entry);
            this.paths.add(entry.toString());
            FilesystemAlterationMonitor.this.onCreate(this.root, entry);
        }

        private void deleteChilds() {
            Entry[] childs = this.getChilds();
            for (int i = 0; i < childs.length; ++i) {
                Entry child = childs[i];
                this.delete(child);
            }
        }

        public void delete(Entry entry) {
            this.childs.remove(entry);
            this.paths.remove(entry.toString());
            entry.deleteChilds();
            FilesystemAlterationMonitor.this.onDelete(this.root, entry);
        }

        public File getFile() {
            return this.file;
        }

        public void markNotChanged() {
            this.lastModified = this.file.lastModified();
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }
    }
}

