/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.HashMap;
import java.util.Map;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import org.ajax4jsf.dnd.Draggable;
import org.ajax4jsf.dnd.Dropzone;
import org.ajax4jsf.dnd.event.DragEvent;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.richfaces.renderkit.CompositeRenderer;
import org.richfaces.renderkit.DnDEventsExchangeMailer;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;

public class DraggableRendererContributor
implements RendererContributor {
    public static final String DRAG_SOURCE_ID = "dragSourceId";
    private static final DnDEventsExchangeMailer.EventCallback dragEventsCallback = new DnDEventsExchangeMailer.EventCallback(){

        void processEvent(FacesEvent facesEvent, UIComponent source, FacesContext facesContext, Object type, Object value) {
            DragEvent dragEvent = (DragEvent)facesEvent;
            dragEvent.setDropTarget((Dropzone)source);
            dragEvent.setDropValue(value);
            dragEvent.setAcceptedTypes(type);
        }
    };
    private static DraggableRendererContributor instance;
    static /* synthetic */ Class class$org$ajax4jsf$framework$resource$PrototypeScript;
    static /* synthetic */ Class class$org$ajax4jsf$dnd$DnDScript;
    static /* synthetic */ Class class$org$ajax4jsf$dnd$Draggable;

    private DraggableRendererContributor() {
    }

    public static synchronized RendererContributor getInstance() {
        if (instance == null) {
            instance = new DraggableRendererContributor();
        }
        return instance;
    }

    public void decode(FacesContext context, UIComponent component, CompositeRenderer compositeRenderer) {
        Map paramMap;
        DnDEventsExchangeMailer eventsExchanger = DnDEventsExchangeMailer.getInstance(context);
        String clientId = component.getClientId(context);
        if (clientId.equals((paramMap = context.getExternalContext().getRequestParameterMap()).get(DRAG_SOURCE_ID))) {
            String dropTargetId = (String)paramMap.get("dropTargetId");
            if (compositeRenderer != null) {
                compositeRenderer.contributorDecodeCallback(component, context, this, dropTargetId);
            }
            Draggable draggable = (Draggable)component;
            eventsExchanger.mailEvent(dropTargetId, component, context, (FacesEvent)new DragEvent(component), dragEventsCallback, draggable.getDragType(), draggable.getDragValue());
        }
    }

    public String[] getStyleDependencies() {
        return new String[]{"/org/richfaces/renderkit/html/css/dragIndicator.xcss"};
    }

    public String[] getScriptDependencies() {
        return new String[]{(class$org$ajax4jsf$framework$resource$PrototypeScript == null ? (class$org$ajax4jsf$framework$resource$PrototypeScript = DraggableRendererContributor.class$("org.ajax4jsf.framework.resource.PrototypeScript")) : class$org$ajax4jsf$framework$resource$PrototypeScript).getName(), "/org/richfaces/renderkit/html/scripts/json/json.js", (class$org$ajax4jsf$dnd$DnDScript == null ? (class$org$ajax4jsf$dnd$DnDScript = DraggableRendererContributor.class$("org.ajax4jsf.dnd.DnDScript")) : class$org$ajax4jsf$dnd$DnDScript).getName(), "/org/richfaces/renderkit/html/scripts/dnd/dnd-common.js", "/org/richfaces/renderkit/html/scripts/dnd/dnd-draggable.js"};
    }

    public ScriptOptions buildOptions(FacesContext context, UIComponent component) {
        if (component instanceof Draggable) {
            Draggable draggable = (Draggable)component;
            DraggableOptions options = new DraggableOptions(draggable);
            Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
            HashMap<String, String> parameters = (HashMap<String, String>)eventOptions.get("parameters");
            if (parameters == null) {
                parameters = new HashMap<String, String>();
            }
            String clientId = component.getClientId(context);
            parameters.put(DRAG_SOURCE_ID, clientId);
            options.addOption("parameters", parameters);
            String indicatorId = draggable.getDragIndicator();
            if (indicatorId != null) {
                UIComponent indicator = null;
                if (component instanceof NamingContainer) {
                    if (component.getParent() != null) {
                        indicator = component.getParent().findComponent(indicatorId);
                    }
                } else {
                    indicator = component.findComponent(indicatorId);
                }
                if (indicator != null) {
                    options.addOption("dragIndicator", indicator.getClientId(context));
                }
            }
            return options;
        }
        return null;
    }

    public String getScriptContribution(FacesContext context, UIComponent component) {
        return null;
    }

    public Class getAcceptableClass() {
        return class$org$ajax4jsf$dnd$Draggable == null ? (class$org$ajax4jsf$dnd$Draggable = DraggableRendererContributor.class$("org.ajax4jsf.dnd.Draggable")) : class$org$ajax4jsf$dnd$Draggable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class DraggableOptions
    extends ScriptOptions {
        public DraggableOptions(Draggable draggable) {
            super((UIComponent)draggable);
            this.addOption("dragType", draggable.getDragType());
            this.addEventHandler("ondragstart", draggable.getOndragstart());
            this.addEventHandler("ondragend", draggable.getOndragend());
        }
    }
}

