/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;

public abstract class SOAPConnectionFactory {
    private static Logger log = Logger.getLogger((Class)SOAPConnectionFactory.class);
    private static final String DEFAULT_SOAP_CONNECTION_FACTORY = "org.jboss.ws.core.soap.SOAPConnectionFactoryImpl";
    private static final String[] alternativeFactories = new String[]{"org.jboss.webservice.soap.SOAPConnectionFactoryImpl", "org.jboss.axis.soap.SOAPConnectionFactoryImpl"};

    public static SOAPConnectionFactory newInstance() throws SOAPException, UnsupportedOperationException {
        PropertyAccessAction action = new PropertyAccessAction(SOAPConnectionFactory.class.getName(), DEFAULT_SOAP_CONNECTION_FACTORY);
        String factoryName = (String)AccessController.doPrivileged(action);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Class<?> factoryClass = loader.loadClass(factoryName);
                return (SOAPConnectionFactory)factoryClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                if (!factoryName.equals(DEFAULT_SOAP_CONNECTION_FACTORY)) {
                    throw e;
                }
                for (int i = 0; i < alternativeFactories.length; ++i) {
                    factoryName = alternativeFactories[i];
                    try {
                        Class<?> factoryClass = loader.loadClass(factoryName);
                        return (SOAPConnectionFactory)factoryClass.newInstance();
                    }
                    catch (ClassNotFoundException e1) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Cannot load factory: " + factoryName));
                        continue;
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new SOAPException("Failed to create SOAPConnectionFactory: " + factoryName, t);
        }
        throw new SOAPException("Cannot find SOAPConnectionFactory implementation");
    }

    public abstract SOAPConnection createConnection() throws SOAPException;

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;
        private String defaultValue;

        PropertyAccessAction(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public Object run() {
            return System.getProperty(this.name, this.defaultValue);
        }
    }
}

