/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    private static ThreadLocal transferBufferLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new byte[512];
        }
    };

    private FileUtil() {
    }

    public static void deleteDirectory(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                FileUtil.deleteDirectory(file);
            }
            file.delete();
            ++i;
        }
        dir.delete();
    }

    public static void zipDirectory(File dir, ZipOutputStream zipOut, String prefix) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + dir);
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("could not list the files of the given pathname: " + dir);
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                FileUtil.zipDirectory(file, zipOut, String.valueOf(prefix) + '/' + file.getName());
            } else {
                FileUtil.zipFile(file, zipOut, prefix);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zipFile(File file, ZipOutputStream zipOut, String prefix) throws IOException {
        FileInputStream fileSource = new FileInputStream(file);
        try {
            zipOut.putNextEntry(new ZipEntry(String.valueOf(prefix) + '/' + file.getName()));
            byte[] transferBuffer = (byte[])transferBufferLocal.get();
            while (true) {
                int length;
                block4: {
                    if ((length = ((InputStream)fileSource).read(transferBuffer)) > 0) break block4;
                    zipOut.closeEntry();
                    break;
                }
                zipOut.write(transferBuffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            ((InputStream)fileSource).close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        ((InputStream)fileSource).close();
    }
}

