/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.Point;
import java.awt.Rectangle;

public class RotateFilter
extends TransformFilter {
    static final long serialVersionUID = 1166374736665848180L;
    private double angle;
    private double cos;
    private double sin;
    private boolean resize = true;

    public RotateFilter() {
        this(Math.PI);
    }

    public RotateFilter(double d) {
        this(d, true);
    }

    public RotateFilter(double d, boolean bl) {
        this.setAngle(d);
        this.resize = bl;
    }

    public void setAngle(double d) {
        this.angle = d;
        this.cos = Math.cos(this.angle);
        this.sin = Math.sin(this.angle);
    }

    public double getAngle() {
        return this.angle;
    }

    protected void transformSpace(Rectangle rectangle) {
        if (this.resize) {
            Point point = new Point(0, 0);
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MAX_VALUE;
            int n3 = Integer.MIN_VALUE;
            int n4 = Integer.MIN_VALUE;
            int n5 = rectangle.width;
            int n6 = rectangle.height;
            int n7 = rectangle.x;
            int n8 = rectangle.y;
            int n9 = 0;
            while (n9 < 4) {
                switch (n9) {
                    case 0: {
                        this.transform(n7, n8, point);
                        break;
                    }
                    case 1: {
                        this.transform(n7 + n5, n8, point);
                        break;
                    }
                    case 2: {
                        this.transform(n7, n8 + n6, point);
                        break;
                    }
                    case 3: {
                        this.transform(n7 + n5, n8 + n6, point);
                        break;
                    }
                }
                n = Math.min(n, point.x);
                n2 = Math.min(n2, point.y);
                n3 = Math.max(n3, point.x);
                n4 = Math.max(n4, point.y);
                ++n9;
            }
            rectangle.x = n;
            rectangle.y = n2;
            rectangle.width = n3 - rectangle.x;
            rectangle.height = n4 - rectangle.y;
        }
    }

    protected void transform(int n, int n2, Point point) {
        point.x = (int)((double)n * this.cos + (double)n2 * this.sin);
        point.y = (int)((double)n2 * this.cos - (double)n * this.sin);
    }

    protected void transformInverse(int n, int n2, double[] dArray) {
        dArray[0] = (double)n * this.cos - (double)n2 * this.sin;
        dArray[1] = (double)n2 * this.cos + (double)n * this.sin;
    }

    public String toString() {
        return "Rotate " + (int)(this.angle * 180.0 / Math.PI);
    }
}

