/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.api.apiBindParameter;
import com.pointbase.api.apiBindParameterBinary;
import com.pointbase.api.apiBindParameterInputStream;
import com.pointbase.api.apiBindParameterInteger;
import com.pointbase.api.apiBindParameterReader;
import com.pointbase.api.apiBindParameterString;
import com.pointbase.api.apiResultHeader;
import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.dbga.dbgaProperties;
import com.pointbase.jdbc.jdbcConnection;
import com.pointbase.jdbc.jdbcDatabaseMetaData;
import com.pointbase.jdbc.jdbcParser;
import com.pointbase.jdbc.jdbcResultSetMetaData;
import com.pointbase.jdbc.jdbcStatement;
import com.pointbase.util.utilInputStreamFromReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;

public class jdbcPreparedStatement
extends jdbcStatement
implements PreparedStatement {
    protected apiBindParameter[] m_Binds;
    protected Vector m_Batch;
    private jdbcResultSetMetaData m_MetaData;
    private static Hashtable m_TypeMappings = new Hashtable();

    public jdbcPreparedStatement(jdbcConnection jdbcConnection2, int n, String string) throws SQLException {
        super(jdbcConnection2, n);
        this.init(string);
    }

    public jdbcPreparedStatement(jdbcConnection jdbcConnection2, int n, String string, int n2) throws SQLException {
        this(jdbcConnection2, n, string);
        this.m_apiStatement.setReturnGeneratedKeys(n2);
    }

    public jdbcPreparedStatement(jdbcConnection jdbcConnection2, int n, String string, int n2, int n3) throws SQLException {
        super(jdbcConnection2, n, n2, n3);
        this.init(string);
    }

    private void init(String string) throws SQLException {
        this.m_sql = string;
        try {
            String string2;
            if (this.m_EscapeProcessing) {
                string2 = jdbcParser.parseEscapeSyntax(string);
                this.m_apiStatement = this.m_apiConnection.prepareStatement(string2);
            } else {
                this.m_apiStatement = this.m_apiConnection.prepareStatement(string);
            }
            this.m_Binds = new apiBindParameter[this.m_apiStatement.getMarkerListSize()];
            if (dbgaProperties.getPropertiesDebugLog()) {
                string2 = this.buildLogInfo();
                this.printDebugInfo(string2 + " Prepare \" " + string + " \" ");
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        this.m_Batch = new Vector();
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            this.validate();
            this.closeResultSets();
            this.bindVariables();
            if (dbgaProperties.getPropertiesDebugLog()) {
                String string = this.buildLogInfo();
                this.printDebugInfo(string + " execute ");
            }
            this.m_apiStatement.execute(this.m_CursorType, this.m_FetchDirection == 2, this.m_max_rows);
            super.processResults();
            return this.getResultSet();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        try {
            throw new dbexcpException(86029, "executeQuery");
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    /*
     * Unable to fully structure code
     */
    public int[] executeBatch() throws BatchUpdateException {
        block10: {
            var1_1 = null;
            var2_2 = 0;
            try {
                try {
                    if (this.m_bClosed) {
                        throw new dbexcpException(86005);
                    }
                    if (this.m_sql.toUpperCase().trim().startsWith("SELECT")) {
                        throw new dbexcpException(86006);
                    }
                    var1_1 = new int[this.m_Batch.size()];
                    var3_3 = this.m_Batch.elements();
                    while (var3_3.hasMoreElements()) {
                        var4_6 = (apiBindParameter[])var3_3.nextElement();
                        var5_8 = 0;
                        while (var5_8 < var4_6.length) {
                            this.bindVariables(var4_6[var5_8]);
                            ++var5_8;
                        }
                        if (dbgaProperties.getPropertiesDebugLog()) {
                            var6_10 = this.buildLogInfo();
                            this.printDebugInfo(var6_10 + " execute ");
                        }
                        this.m_apiStatement.execute(this.m_CursorType, this.m_FetchDirection == 2, this.m_max_rows);
                        this.processResults();
                        var1_1[var2_2] = this.m_rowCount;
                        ++var2_2;
                    }
                    break block10;
                }
                catch (dbexcpException var3_4) {
                    throw var3_4.getSQLException();
                }
            }
            catch (SQLException var3_5) {
                var4_7 = new int[var2_2];
                var5_9 = 0;
                ** while (var5_9 < var4_7.length)
            }
lbl-1000:
            // 1 sources

            {
                var4_7[var5_9] = var1_1[var5_9];
                ++var5_9;
                continue;
            }
lbl37:
            // 1 sources

            throw new BatchUpdateException(var3_5.getMessage(), var3_5.getSQLState(), var3_5.getErrorCode(), var4_7);
        }
        return var1_1;
    }

    public int executeUpdate() throws SQLException {
        this.executeQuery();
        return this.m_rowCount;
    }

    public int executeUpdate(String string) throws SQLException {
        try {
            throw new dbexcpException(86029, "executeUpdate");
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        int n3 = this.validateAndTranslate(n2);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n3, null));
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        int n2 = this.validateAndTranslate(-7);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, new Boolean(bl).toString()));
    }

    public void setByte(int n, byte by) throws SQLException {
        int n2 = this.validateAndTranslate(-6);
        this.setBind((apiBindParameter)new apiBindParameterInteger(n - 1, n2, new Integer(by)));
    }

    public void setShort(int n, short s) throws SQLException {
        int n2 = this.validateAndTranslate(5);
        this.setBind((apiBindParameter)new apiBindParameterInteger(n - 1, n2, new Integer(s)));
    }

    public void setInt(int n, int n2) throws SQLException {
        int n3 = this.validateAndTranslate(4);
        this.setBind((apiBindParameter)new apiBindParameterInteger(n - 1, n3, new Integer(n2)));
    }

    public void setLong(int n, long l) throws SQLException {
        int n2 = this.validateAndTranslate(-5);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, Long.toString(l)));
    }

    public void setFloat(int n, float f) throws SQLException {
        int n2 = this.validateAndTranslate(6);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, Double.toString(f)));
    }

    public void setDouble(int n, double d) throws SQLException {
        int n2 = this.validateAndTranslate(8);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, Double.toString(d)));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull(n, 2);
            return;
        }
        int n2 = this.validateAndTranslate(2);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, bigDecimal.toString()));
    }

    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.setNull(n, 12);
        } else {
            int n2 = this.validateAndTranslate(12);
            this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, string));
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray.length < 4096) {
            this.setBind((apiBindParameter)new apiBindParameterBinary(n - 1, 121, byArray));
        } else {
            this.setInputStream(n, this.validateAndTranslate(-4), new ByteArrayInputStream(byArray), byArray.length, null);
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        int n2 = this.validateAndTranslate(91);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, date.toString()));
    }

    public void setTime(int n, Time time) throws SQLException {
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        int n2 = this.validateAndTranslate(92);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, time.toString()));
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        int n2 = this.validateAndTranslate(93);
        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, timestamp.toString()));
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, -1);
            return;
        }
        int n3 = this.validateAndTranslate(-1);
        this.setInputStream(n, n3, inputStream, n2, null);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, -1);
            return;
        }
        int n3 = this.validateAndTranslate(-1);
        this.setInputStream(n, n3, inputStream, n2, "UTF8");
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, -4);
            return;
        }
        int n3 = this.validateAndTranslate(-4);
        this.setInputStream(n, n3, inputStream, n2, null);
    }

    public void clearParameters() throws SQLException {
        this.resetBindElements();
        try {
            if (this.m_apiStatement != null) {
                this.m_apiStatement.clearBindParameters();
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            this.validate();
            int n4 = this.validateAndTranslate(n2);
            if (object == null) {
                this.setNull(n, n2);
            } else {
                switch (n2) {
                    case 1111: {
                        if (object instanceof Serializable) {
                            try {
                                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                                objectOutputStream.writeObject(object);
                                objectOutputStream.flush();
                                objectOutputStream.close();
                                byte[] byArray = byteArrayOutputStream.toByteArray();
                                this.setBind((apiBindParameter)new apiBindParameterBinary(n - 1, 121, byArray));
                                break;
                            }
                            catch (IOException iOException) {
                                throw new dbexcpException(86013, new Object[]{"setObject(...)", iOException.toString()});
                            }
                        }
                        throw new dbexcpException(86012, new Object[]{object.getClass().getName()});
                    }
                    case 93: {
                        String string = object.toString();
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    case 92: {
                        String string = object.toString();
                        if (object instanceof Timestamp) {
                            string = object.toString();
                            string.substring(string.indexOf(32) + 1, string.length());
                        }
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    case 91: {
                        String string = object.toString();
                        if (object instanceof Timestamp) {
                            string = object.toString().substring(0, 18);
                        }
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: {
                        if (object instanceof InputStream) {
                            this.setInputStream(n, n4, (InputStream)object, n3, null);
                        }
                        if (object instanceof byte[]) {
                            this.setBytes(n, (byte[])object);
                            break;
                        }
                        this.setString(n, object.toString());
                        break;
                    }
                    case -6: 
                    case 4: 
                    case 5: {
                        Integer n5 = null;
                        n5 = object instanceof Boolean ? new Integer((Boolean)object != false ? "1" : "0") : (object instanceof Float ? new Integer(((Float)object).intValue()) : (object instanceof Double ? new Integer(((Double)object).intValue()) : (object instanceof Long ? new Integer(((Long)object).intValue()) : (object instanceof BigDecimal ? new Integer(((BigDecimal)object).intValue()) : new Integer(object.toString())))));
                        this.setBind((apiBindParameter)new apiBindParameterInteger(n - 1, n4, n5));
                        break;
                    }
                    case -5: {
                        String string = object.toString();
                        if (object instanceof Boolean) {
                            string = (Boolean)object != false ? "1" : "0";
                        } else if (object instanceof Float) {
                            string = Long.toString((long)((Float)object).floatValue());
                        } else if (object instanceof Double) {
                            string = Long.toString((long)((Double)object).doubleValue());
                        } else if (object instanceof BigDecimal) {
                            string = Long.toString(((BigDecimal)object).longValue());
                        } else if (object instanceof Integer) {
                            string = Long.toString(((Integer)object).longValue());
                        }
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    case 2: 
                    case 3: {
                        String string = object.toString();
                        if (object instanceof Boolean) {
                            string = (Boolean)object != false ? "1" : "0";
                        } else if (object instanceof Float) {
                            string = BigDecimal.valueOf((long)((Float)object).floatValue()).toString();
                        } else if (object instanceof Double) {
                            string = BigDecimal.valueOf((long)((Double)object).doubleValue()).toString();
                        } else if (object instanceof Integer) {
                            string = BigDecimal.valueOf(((Integer)object).longValue()).toString();
                        } else if (object instanceof Long) {
                            string = BigDecimal.valueOf((Long)object).toString();
                        }
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    case 7: {
                        String string = object.toString();
                        if (object instanceof Boolean) {
                            string = (Boolean)object != false ? "1" : "0";
                        } else if (object instanceof BigDecimal) {
                            string = Float.toString(((BigDecimal)object).floatValue());
                        } else if (object instanceof Double) {
                            string = Float.toString(((Double)object).floatValue());
                        } else if (object instanceof Integer) {
                            string = Float.toString(((Integer)object).floatValue());
                        } else if (object instanceof Long) {
                            string = Float.toString(((Long)object).floatValue());
                        }
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    case 6: 
                    case 8: {
                        String string = object.toString();
                        if (object instanceof Boolean) {
                            string = (Boolean)object != false ? "1" : "0";
                        } else if (object instanceof BigDecimal) {
                            string = Double.toString(((BigDecimal)object).doubleValue());
                        } else if (object instanceof Float) {
                            string = Double.toString(((Float)object).doubleValue());
                        } else if (object instanceof Integer) {
                            string = Double.toString(((Integer)object).doubleValue());
                        } else if (object instanceof Long) {
                            string = Double.toString(((Long)object).doubleValue());
                        }
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, string));
                        break;
                    }
                    default: {
                        this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n4, object.toString()));
                    }
                }
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object instanceof Timestamp) {
            this.setObject(n, object, 93);
        } else if (object instanceof Time) {
            this.setObject(n, object, 92);
        } else if (object instanceof Date) {
            this.setObject(n, object, 91);
        } else if (object instanceof Integer) {
            this.setObject(n, object, 4);
        } else if (object instanceof Short) {
            this.setObject(n, object, 5);
        } else if (object instanceof Float) {
            this.setObject(n, object, 6);
        } else if (object instanceof Double) {
            this.setObject(n, object, 8);
        } else if (object instanceof String) {
            this.setObject(n, object, 12);
        } else if (object instanceof Long) {
            this.setObject(n, object, -5);
        } else if (object instanceof Boolean) {
            this.setObject(n, object, -7);
        } else if (object instanceof Byte) {
            this.setObject(n, object, -6);
        } else if (object instanceof BigDecimal) {
            this.setObject(n, object, 3);
        } else if (object instanceof byte[]) {
            this.setObject(n, object, -4);
        } else if (object instanceof Serializable) {
            this.setObject(n, object, 1111);
        } else {
            this.setObject(n, object, 12);
        }
    }

    public boolean execute() throws SQLException {
        return this.executeQuery() != null;
    }

    public boolean execute(String string) throws SQLException {
        try {
            throw new dbexcpException(86029, "execute");
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.setBinaryStream(n, blob.getBinaryStream(), (int)blob.length());
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (reader == null) {
            this.setNull(n, -1);
            return;
        }
        int n3 = this.validateAndTranslate(-1);
        this.setReader(n, n3, reader, n2);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        try {
            try {
                dbgaProperties.setPropertiesStreamCheckEnable(false);
                this.setUnicodeStream(n, new utilInputStreamFromReader(clob.getCharacterStream(), "UTF8"), (int)clob.length() * 3);
                dbgaProperties.setPropertiesStreamCheckEnable(true);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new dbexcpException(75001, new Object[]{"UTF8"});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        } else {
            calendar.setTime(date);
            java.util.Date date2 = calendar.getTime();
            this.setDate(n, new Date(date2.getTime()));
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        } else {
            calendar.setTime(time);
            java.util.Date date = calendar.getTime();
            this.setTime(n, new Time(date.getTime()));
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        } else {
            calendar.setTime(timestamp);
            java.util.Date date = calendar.getTime();
            this.setTimestamp(n, new Timestamp(date.getTime()));
        }
    }

    public void addBatch() throws SQLException {
        try {
            this.validate();
            apiBindParameter[] apiBindParameterArray = this.copyContents(this.m_Binds);
            this.m_Batch.addElement(apiBindParameterArray);
            this.resetBindElements();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void clearBatch() throws SQLException {
        this.m_Batch.removeAllElements();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            this.validate();
            if (this.m_MetaData == null) {
                this.m_MetaData = this.getMetaDataFromApi();
            }
            return this.m_MetaData;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void close() throws SQLException {
        this.clearParameters();
        if (this.m_MetaData != null) {
            this.m_MetaData.releaseResources();
        }
        super.close();
    }

    protected void bindVariables() throws dbexcpException {
        if (this.m_Binds == null) {
            return;
        }
        int n = 0;
        while (n < this.m_Binds.length) {
            apiBindParameter apiBindParameter2 = this.m_Binds[n];
            if (apiBindParameter2 != null) {
                this.m_apiStatement.bind(apiBindParameter2);
            }
            ++n;
        }
        this.resetBindElements();
    }

    protected void bindVariables(apiBindParameter apiBindParameter2) throws dbexcpException {
        if (apiBindParameter2 != null) {
            this.m_apiStatement.bind(apiBindParameter2);
        }
    }

    protected jdbcResultSetMetaData getMetaDataFromApi() throws dbexcpException {
        apiResultHeader apiResultHeader2;
        if (this.m_MetaData == null && (apiResultHeader2 = this.m_apiStatement.fetchMetaData(0)) != null) {
            this.m_MetaData = new jdbcResultSetMetaData(this.m_apiStatement.fetchMetaData(0));
        }
        return this.m_MetaData;
    }

    protected apiResultHeader getResultHeader() throws dbexcpException {
        this.getMetaDataFromApi();
        return this.m_MetaData.getHeader();
    }

    private void resetBindElements() {
        if (this.m_Binds == null) {
            return;
        }
        int n = this.m_Binds.length;
        int n2 = 0;
        while (n2 < n) {
            this.m_Binds[n2] = null;
            ++n2;
        }
    }

    protected static int translateJavaSQLTypeToSQLStandard(int n) throws SQLException {
        Integer n2 = (Integer)m_TypeMappings.get(new Integer(n));
        if (n2 == null) {
            throw new dbexcpException(25006, "Cannot Bind a Java SQL Type that is not a SQL standard type: " + n).getSQLException();
        }
        return n2;
    }

    public void setBind(apiBindParameter apiBindParameter2) throws SQLException {
        try {
            int n = apiBindParameter2.getPosition();
            if (n >= this.m_Binds.length) {
                throw new dbexcpException(86014, new Object[]{new Integer(n + 1)});
            }
            this.m_Binds[n] = apiBindParameter2;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setURL(int n, URL uRL) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("setURL");
    }

    private void setInputStream(int n, int n2, InputStream inputStream, int n3, String string) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, n2);
            return;
        }
        try {
            if (n3 >= 4096 || !dbgaProperties.getPropertiesStreamCheckEnabled()) {
                this.setBind((apiBindParameter)new apiBindParameterInputStream(n - 1, n2, inputStream, n3, this.getCommandType()));
            } else if (n2 == 30) {
                this.setBind((apiBindParameter)new apiBindParameterBinary(n - 1, 121, inputStream, n3));
            } else {
                n2 = 12;
                this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, inputStream, n3, string));
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    private void setReader(int n, int n2, Reader reader, int n3) throws SQLException {
        if (reader == null) {
            this.setNull(n, n2);
            return;
        }
        try {
            if (n3 * 3 >= 4096 || !dbgaProperties.getPropertiesStreamCheckEnabled()) {
                this.setBind((apiBindParameter)new apiBindParameterReader(n - 1, n2, reader, n3, this.getCommandType()));
            } else {
                n2 = 12;
                this.setBind((apiBindParameter)new apiBindParameterString(n - 1, n2, reader, n3));
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public apiBindParameter[] copyContents(apiBindParameter[] apiBindParameterArray) {
        apiBindParameter[] apiBindParameterArray2 = new apiBindParameter[apiBindParameterArray.length];
        System.arraycopy(apiBindParameterArray, 0, apiBindParameterArray2, 0, apiBindParameterArray.length);
        return apiBindParameterArray2;
    }

    private void validate() throws dbexcpException {
        if (this.m_bClosed) {
            throw new dbexcpException(86005);
        }
    }

    private void validateAndThrowSQL() throws SQLException {
        try {
            this.validate();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    private int validateAndTranslate(int n) throws SQLException {
        try {
            this.validate();
            return jdbcPreparedStatement.translateJavaSQLTypeToSQLStandard(n);
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    static {
        m_TypeMappings.put(new Integer(-6), new Integer(5));
        m_TypeMappings.put(new Integer(5), new Integer(5));
        m_TypeMappings.put(new Integer(4), new Integer(4));
        m_TypeMappings.put(new Integer(-5), new Integer(9));
        m_TypeMappings.put(new Integer(6), new Integer(6));
        m_TypeMappings.put(new Integer(7), new Integer(7));
        m_TypeMappings.put(new Integer(8), new Integer(8));
        m_TypeMappings.put(new Integer(2), new Integer(2));
        m_TypeMappings.put(new Integer(3), new Integer(3));
        m_TypeMappings.put(new Integer(1), new Integer(1));
        m_TypeMappings.put(new Integer(12), new Integer(12));
        m_TypeMappings.put(new Integer(-1), new Integer(40));
        m_TypeMappings.put(new Integer(91), new Integer(91));
        m_TypeMappings.put(new Integer(92), new Integer(92));
        m_TypeMappings.put(new Integer(93), new Integer(93));
        m_TypeMappings.put(new Integer(-7), new Integer(16));
        m_TypeMappings.put(new Integer(-2), new Integer(30));
        m_TypeMappings.put(new Integer(-3), new Integer(30));
        m_TypeMappings.put(new Integer(-4), new Integer(30));
        m_TypeMappings.put(new Integer(1111), new Integer(121));
        m_TypeMappings.put(new Integer(2004), new Integer(30));
        m_TypeMappings.put(new Integer(2005), new Integer(40));
    }
}

