/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.encoding.jaxb;

import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.jboss.com.sun.xml.ws.encoding.soap.DeserializationException;
import org.jboss.com.sun.xml.ws.encoding.soap.SerializationException;
import org.jboss.com.sun.xml.ws.streaming.XMLStreamReaderUtil;

public final class JAXBTypeSerializer {
    private JAXBTypeSerializer() {
    }

    public static void serialize(Object obj, XMLStreamWriter writer, JAXBContext context) {
        try {
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.marshal(obj, writer);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    public static void serialize(Object obj, XMLStreamWriter writer, JAXBContext context, Marshaller marshaller) {
        try {
            if (marshaller == null) {
                marshaller = context.createMarshaller();
            }
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.marshal(obj, writer);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    public static void serializeDocument(Object obj, XMLStreamWriter writer, JAXBContext context) {
        try {
            Marshaller marshaller = context.createMarshaller();
            marshaller.marshal(obj, writer);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    public static void serialize(Object obj, OutputStream os, JAXBContext context, Marshaller marshaller) {
        try {
            if (marshaller == null) {
                marshaller = context.createMarshaller();
            }
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.marshal(obj, os);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    public static void serialize(Object obj, OutputStream os, JAXBContext context) {
        try {
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.marshal(obj, os);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    public static DOMSource serialize(Object bean, JAXBContext context) {
        try {
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            DOMResult domResult = new DOMResult();
            marshaller.marshal(bean, (Result)domResult);
            return new DOMSource(domResult.getNode());
        }
        catch (JAXBException e) {
            throw new SerializationException(e);
        }
    }

    public static Object deserialize(XMLStreamReader reader, JAXBContext context) {
        Object obj = null;
        try {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            if (reader.getEventType() == 1) {
                obj = unmarshaller.unmarshal(reader);
            }
            if (reader.getEventType() == 4 && reader.isWhiteSpace()) {
                XMLStreamReaderUtil.nextContent(reader);
            }
            return obj;
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
    }

    public static Object deserialize(XMLStreamReader reader, JAXBContext context, Unmarshaller bc) {
        Object obj = null;
        try {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            if (bc != null) {
                unmarshaller.setAttachmentUnmarshaller(bc.getAttachmentUnmarshaller());
            }
            if (reader.getEventType() == 1) {
                obj = unmarshaller.unmarshal(reader);
            }
            if (reader.getEventType() == 4 && reader.isWhiteSpace()) {
                XMLStreamReaderUtil.nextContent(reader);
            }
            return obj;
        }
        catch (DeserializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
    }

    public static Object deserialize(Source source, JAXBContext context) {
        try {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return unmarshaller.unmarshal(source);
        }
        catch (JAXBException e) {
            throw new DeserializationException(e);
        }
    }
}

