/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.tiles;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ApplicationConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ComponentDefinition;
import org.apache.struts.tiles.Controller;
import org.apache.struts.tiles.DefinitionsFactory;
import org.apache.struts.tiles.DefinitionsFactoryException;
import org.apache.struts.tiles.DefinitionsUtil;

public class TilesRequestProcessor
extends RequestProcessor {
    public static final boolean debug = true;
    private DefinitionsFactory definitionsFactory;

    public void init(ActionServlet servlet, ApplicationConfig appConfig) throws ServletException {
        super.init(servlet, appConfig);
        this.initDefinitionsMapping();
    }

    protected void initDefinitionsMapping() throws ServletException {
        this.definitionsFactory = DefinitionsUtil.getDefinitionsFactory(this.getServletContext());
        if (this.definitionsFactory == null) {
            this.log("Error - TilesRequestProcessor : Definition Factory not found for subapp '" + this.appConfig.getPrefix() + "'. " + "Do you have declared appropriate plugin in struts-config.xml ?");
            return;
        }
        this.log("Tiles definition factory found for request processor '" + this.appConfig.getPrefix() + "'.");
    }

    protected boolean processTilesDefinition(String definitionName, boolean contextRelative, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean doInclude = false;
        Controller controller = null;
        String uri = null;
        ComponentContext tileContext = null;
        try {
            ComponentDefinition definition;
            tileContext = ComponentContext.getContext((ServletRequest)request);
            boolean bl = doInclude = tileContext != null;
            if (this.definitionsFactory != null && (definition = this.definitionsFactory.getDefinition(definitionName, (ServletRequest)request, this.getServletContext())) != null) {
                uri = definition.getPath();
                controller = definition.getOrCreateController();
                if (tileContext == null) {
                    tileContext = new ComponentContext(definition.getAttributes());
                    ComponentContext.setContext(tileContext, (ServletRequest)request);
                } else {
                    tileContext.addMissing(definition.getAttributes());
                }
            }
            if ((definition = DefinitionsUtil.getActionDefinition((ServletRequest)request)) != null) {
                if (definition.getPath() != null) {
                    uri = definition.getPath();
                }
                if (definition.getOrCreateController() != null) {
                    controller = definition.getOrCreateController();
                }
                if (tileContext == null) {
                    tileContext = new ComponentContext(definition.getAttributes());
                    ComponentContext.setContext(tileContext, (ServletRequest)request);
                } else {
                    tileContext.addMissing(definition.getAttributes());
                }
            }
        }
        catch (InstantiationException ex) {
            throw new ServletException("Can't create associated controller", (Throwable)ex);
        }
        catch (DefinitionsFactoryException ex) {
            throw new ServletException((Throwable)ex);
        }
        if (uri == null) {
            return false;
        }
        if (controller != null) {
            controller.perform(tileContext, request, response, this.getServletContext());
        }
        if (doInclude) {
            this.doInclude(uri, request, response);
        } else {
            super.doForward(uri, request, response);
        }
        return true;
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted()) {
            this.doInclude(uri, request, response);
        } else {
            super.doForward(uri, request, response);
        }
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        if (forward == null) {
            return;
        }
        System.out.println("processActionForward(" + forward.getPath() + ", " + forward.getContextRelative() + ")");
        if (this.processTilesDefinition(forward.getPath(), forward.getContextRelative(), request, response)) {
            System.out.println("  '" + forward.getPath() + "' - processed as definition");
            return;
        }
        System.out.println("  '" + forward.getPath() + "' - processed as uri");
        super.processForwardConfig(request, response, forward);
    }

    protected void internalModuleRelativeForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.processTilesDefinition(uri, false, request, response)) {
            return;
        }
        super.internalModuleRelativeForward(uri, request, response);
    }

    protected void internalModuleRelativeInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.processTilesDefinition(uri, false, request, response)) {
            return;
        }
        super.internalModuleRelativeInclude(uri, request, response);
    }

    static {
        debug = true;
    }
}

