/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import java.util.ArrayList;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerImplMBean;
import org.jboss.tm.TxManager;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.tm.recovery.Recoverable;
import org.jboss.tm.recovery.RecoveryLogger;
import org.jboss.tm.recovery.RecoveryLoggerInstance;
import org.jboss.tm.recovery.RecoveryManager;
import org.jboss.tm.recovery.RecoveryManagerServiceMBean;

public class RecoveryManagerService
extends ServiceMBeanSupport
implements NotificationListener,
RecoveryManagerServiceMBean {
    private ObjectName xidFactory;
    private ObjectName txManager;
    private RecoveryLogger recoveryLogger;
    private XidFactoryMBean xidFactoryObj;
    private TxManager txManagerObj;
    private ArrayList xaResourceManagers = new ArrayList();
    private RecoveryManager recoveryManager;

    protected void startService() throws Exception {
        super.startService();
        this.xidFactoryObj = (XidFactoryMBean)this.getServer().getAttribute(this.xidFactory, "Instance");
        this.txManagerObj = (TxManager)this.getServer().getAttribute(this.txManager, "TransactionManager");
        this.txManagerObj.setRecoveryLogger(this.recoveryLogger);
        NotificationFilter filter = new NotificationFilter(){
            private static final long serialVersionUID = 1L;

            public boolean isNotificationEnabled(Notification n) {
                return n.getType().equals("org.jboss.system.server.started");
            }
        };
        this.getServer().addNotificationListener(ServerImplMBean.OBJECT_NAME, this, filter, null);
    }

    protected void stopService() throws Exception {
        super.stopService();
    }

    public void handleNotification(Notification notification, Object handback) {
        this.log.info((Object)"RECEIVED STARTUP NOTIFICATION");
        if (this.recoveryLogger != null) {
            this.recover();
        }
        this.txManagerObj.clearRecoveryPending();
    }

    public ObjectName getXidFactory() {
        return this.xidFactory;
    }

    public void setXidFactory(ObjectName xidFactory) {
        this.xidFactory = xidFactory;
    }

    public ObjectName getTransactionManager() {
        return this.txManager;
    }

    public void setTransactionManager(ObjectName txManager) {
        this.txManager = txManager;
    }

    public void setRecoveryLogger(RecoveryLoggerInstance recoveryLogger) {
        this.recoveryLogger = recoveryLogger.getInstance();
    }

    public void recover() {
        try {
            this.recoveryManager = new RecoveryManager(this.xidFactoryObj, this.txManagerObj, this.recoveryLogger);
            this.recoveryManager.recover(this.xaResourceManagers);
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to recover", (Throwable)e);
        }
    }

    public void registerRecoverable(Recoverable recoverable) {
        this.xaResourceManagers.add(recoverable);
    }
}

