/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionMap
extends BaseContextMap {
    private final HttpServletRequest request;

    SessionMap(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void clear() {
        HttpSession session = this.getSession();
        String name = null;
        Enumeration e = this.getSession().getAttributeNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            session.removeAttribute(name);
        }
    }

    @Override
    public void putAll(Map t) {
        HttpSession session = this.getSession();
        for (Map.Entry entry : t.entrySet()) {
            session.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.getSession().getAttribute(key.toString());
    }

    @Override
    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        HttpSession session = this.getSession();
        Object result = session.getAttribute(key.toString());
        session.setAttribute(key.toString(), value);
        return result;
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        String keyString = key.toString();
        HttpSession session = this.getSession();
        Object result = session.getAttribute(keyString);
        session.removeAttribute(keyString);
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getSession().getAttribute(key.toString()) != null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SessionMap)) {
            return false;
        }
        return super.equals(obj);
    }

    private HttpSession getSession() {
        return this.request.getSession(true);
    }

    @Override
    public int hashCode() {
        int hashCode = 7 * this.request.getSession().hashCode();
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            hashCode += ((Object)i.next()).hashCode();
        }
        return hashCode;
    }

    protected Iterator<Map.Entry<String, Object>> getEntryIterator() {
        return new BaseContextMap.EntryIterator(this.getSession().getAttributeNames());
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return new BaseContextMap.KeyIterator(this.getSession().getAttributeNames());
    }

    protected Iterator<Object> getValueIterator() {
        return new BaseContextMap.ValueIterator(this.getSession().getAttributeNames());
    }
}

