/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.jasperreports;

import dori.jasper.engine.JRDataSource;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporter;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JasperExportManager;
import dori.jasper.engine.JasperFillManager;
import dori.jasper.engine.JasperManager;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.JasperReport;
import dori.jasper.engine.export.JRCsvExporter;
import dori.jasper.engine.export.JRHtmlExporter;
import dori.jasper.engine.export.JRXlsExporter;
import dori.jasper.engine.export.JRXmlExporter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.util.ServletValueStack;
import webwork.view.jasperreports.ValueStackDataSource;
import webwork.view.jasperreports.ValueStackShadowMap;

public class JasperReportViewServlet
extends HttpServlet {
    protected static Log log = LogFactory.getLog((Class)(class$webwork$view$jasperreports$JasperReportViewServlet == null ? (class$webwork$view$jasperreports$JasperReportViewServlet = JasperReportViewServlet.class$("webwork.view.jasperreports.JasperReportViewServlet")) : class$webwork$view$jasperreports$JasperReportViewServlet));
    public static final String FORMAT_PDF = "PDF";
    public static final String FORMAT_XML = "XML";
    public static final String FORMAT_HTML = "HTML";
    public static final String FORMAT_XLS = "XLS";
    public static final String FORMAT_CSV = "CSV";
    static /* synthetic */ Class class$webwork$view$jasperreports$JasperReportViewServlet;

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ServletValueStack stack = ServletValueStack.getStack((ServletRequest)request);
        String dataSource = request.getParameter("dataSource");
        ValueStackDataSource stackDataSource = new ValueStackDataSource(stack, dataSource);
        String outputFormat = request.getParameter("format");
        if (outputFormat == null) {
            outputFormat = FORMAT_PDF;
        }
        if (!"contype".equals(request.getHeader("User-Agent"))) {
            String systemId = this.getServletContext().getRealPath(request.getServletPath());
            ValueStackShadowMap parameters = new ValueStackShadowMap(stack);
            File directory = new File(systemId.substring(0, systemId.lastIndexOf(File.separator)));
            parameters.put("reportDirectory", directory);
            byte[] output = null;
            JasperPrint jasperPrint = null;
            try {
                JasperReport jasperReport = JasperManager.loadReport((String)systemId);
                jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (JRDataSource)stackDataSource);
            }
            catch (JRException e) {
                log.error((Object)("Error building report for uri " + systemId), (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            try {
                if (outputFormat.equals(FORMAT_PDF)) {
                    response.setContentType("application/pdf");
                    output = JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
                } else {
                    JRCsvExporter exporter = null;
                    if (outputFormat.equals(FORMAT_CSV)) {
                        response.setContentType("text/plain");
                        exporter = new JRCsvExporter();
                    } else if (outputFormat.equals(FORMAT_HTML)) {
                        response.setContentType("text/html");
                        exporter = new JRHtmlExporter();
                    } else if (outputFormat.equals(FORMAT_XLS)) {
                        response.setContentType("application/vnd.ms-excel");
                        exporter = new JRXlsExporter();
                    } else if (outputFormat.equals(FORMAT_XML)) {
                        response.setContentType("text/xml");
                        exporter = new JRXmlExporter();
                    } else {
                        throw new ServletException("Unknown report format: " + outputFormat);
                    }
                    output = this.exportReportToBytes(jasperPrint, (JRExporter)exporter);
                }
            }
            catch (JRException e) {
                String message = "Error producing " + outputFormat + " report for uri " + systemId;
                log.error((Object)message, (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.setContentLength(output.length);
            try {
                log.debug((Object)("Writing " + output.length + " bytes to output stream"));
                ServletOutputStream ouputStream = response.getOutputStream();
                ouputStream.write(output);
                ouputStream.flush();
                ouputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Error writing report output", (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            response.setContentType("application/pdf");
            response.setContentLength(0);
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.close();
        }
        catch (IOException e) {
            log.error((Object)"Error writing report output", (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private byte[] exportReportToBytes(JasperPrint jasperPrint, JRExporter exporter) throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.exportReport();
        byte[] output = baos.toByteArray();
        return output;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

