/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.jboss.mx.server.ServerConfig;
import org.jboss.mx.standardmbean.StandardMBeanDelegate;
import org.jboss.mx.standardmbean.StandardMBeanDelegateFactory;
import org.jboss.util.NestedRuntimeException;

public class StandardMBean
implements DynamicMBean {
    private StandardMBeanDelegate delegate;

    public StandardMBean(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        ServerConfig config = ServerConfig.getInstance();
        StandardMBeanDelegateFactory factory = config.getStandardMBeanDelegateFactory();
        this.delegate = factory.createStandardMBean(implementation, mbeanInterface);
        this.cacheMBeanInfo(this.buildMBeanInfo());
    }

    protected StandardMBean(Class mbeanInterface) throws NotCompliantMBeanException {
        ServerConfig config = ServerConfig.getInstance();
        StandardMBeanDelegateFactory factory = config.getStandardMBeanDelegateFactory();
        this.delegate = factory.createStandardMBean(this, mbeanInterface);
        this.cacheMBeanInfo(this.buildMBeanInfo());
    }

    public Object getImplementation() {
        return this.delegate.getImplementation();
    }

    public void setImplementation(Object implementation) throws NotCompliantMBeanException {
        this.delegate.setImplementation(implementation);
    }

    public Class getImplementationClass() {
        return this.delegate.getImplementation().getClass();
    }

    public final Class getMBeanInterface() {
        return this.delegate.getMBeanInterface();
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.delegate.getAttribute(attribute);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.delegate.setAttribute(attribute);
    }

    public AttributeList getAttributes(String[] attributes) {
        return this.delegate.getAttributes(attributes);
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return this.delegate.setAttributes(attributes);
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return this.delegate.invoke(actionName, params, signature);
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo info = this.getCachedMBeanInfo();
        if (info == null) {
            try {
                info = this.buildMBeanInfo();
                this.cacheMBeanInfo(info);
            }
            catch (NotCompliantMBeanException e) {
                throw new NestedRuntimeException("Unexcepted exception ", (Throwable)e);
            }
        }
        return info;
    }

    protected String getClassName(MBeanInfo info) {
        return info.getClassName();
    }

    protected String getDescription(MBeanInfo info) {
        return info.getDescription();
    }

    protected String getDescription(MBeanFeatureInfo info) {
        return info.getDescription();
    }

    protected String getDescription(MBeanAttributeInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanOperationInfo info) {
        return this.getDescription((MBeanFeatureInfo)info);
    }

    protected String getDescription(MBeanConstructorInfo info, MBeanParameterInfo param, int sequence) {
        return param.getDescription();
    }

    protected String getDescription(MBeanOperationInfo info, MBeanParameterInfo param, int sequence) {
        return param.getDescription();
    }

    protected String getParameterName(MBeanConstructorInfo info, MBeanParameterInfo param, int sequence) {
        return param.getName();
    }

    protected String getParameterName(MBeanOperationInfo info, MBeanParameterInfo param, int sequence) {
        return param.getName();
    }

    protected int getImpact(MBeanOperationInfo info) {
        return info.getImpact();
    }

    protected MBeanConstructorInfo[] getConstructors(MBeanConstructorInfo[] constructors, Object implementation) {
        if (implementation == this) {
            return constructors;
        }
        return null;
    }

    protected MBeanInfo getCachedMBeanInfo() {
        return this.delegate.getCachedMBeanInfo();
    }

    protected void cacheMBeanInfo(MBeanInfo info) {
        this.delegate.cacheMBeanInfo(info);
    }

    private final MBeanInfo buildMBeanInfo() throws NotCompliantMBeanException {
        String description;
        String name;
        String description2;
        MBeanParameterInfo[] parameters;
        int i;
        MBeanInfo info = this.delegate.buildMBeanInfo();
        String className = this.getClassName(info);
        String mainDescription = this.getDescription(info);
        MBeanAttributeInfo[] attributes = info.getAttributes();
        MBeanConstructorInfo[] constructors = info.getConstructors();
        MBeanOperationInfo[] operations = info.getOperations();
        MBeanNotificationInfo[] notifications = info.getNotifications();
        for (i = 0; i < attributes.length; ++i) {
            MBeanAttributeInfo attribute = attributes[i];
            String description3 = this.getDescription(attribute);
            attributes[i] = new MBeanAttributeInfo(attribute.getName(), attribute.getType(), description3, attribute.isReadable(), attribute.isWritable(), attribute.isIs());
        }
        if (this.equals(this.delegate.getImplementation())) {
            constructors = this.getConstructors(constructors, this);
            for (i = 0; i < constructors.length; ++i) {
                MBeanConstructorInfo constructor = constructors[i];
                parameters = constructor.getSignature();
                for (int j = 0; j < parameters.length; ++j) {
                    MBeanParameterInfo param = parameters[j];
                    description2 = this.getDescription(constructor, param, j);
                    name = this.getParameterName(constructor, param, j);
                    parameters[j] = new MBeanParameterInfo(name, param.getType(), description2);
                }
                description = this.getDescription(constructor);
                constructors[i] = new MBeanConstructorInfo(constructor.getName(), description, parameters);
            }
        } else {
            constructors = new MBeanConstructorInfo[]{};
        }
        for (i = 0; i < operations.length; ++i) {
            MBeanOperationInfo operation = operations[i];
            parameters = operation.getSignature();
            for (int j = 0; j < parameters.length; ++j) {
                MBeanParameterInfo param = parameters[j];
                description2 = this.getDescription(operation, param, j);
                name = this.getParameterName(operation, param, j);
                parameters[j] = new MBeanParameterInfo(name, param.getType(), description2);
            }
            description = this.getDescription(operation);
            int impact = this.getImpact(operation);
            operations[i] = new MBeanOperationInfo(operation.getName(), description, parameters, operation.getReturnType(), impact);
        }
        info = new MBeanInfo(className, mainDescription, attributes, constructors, operations, notifications);
        return info;
    }
}

