/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.session;

import javax.ejb.EJBMetaData;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.Remote;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.annotation.ejb.RemoteHome;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.session.BaseSessionRemoteProxy;
import org.jboss.logging.Logger;
import org.jboss.proxy.ejb.EJBMetaDataImpl;
import org.jboss.proxy.ejb.handle.HomeHandleImpl;

public abstract class BaseSessionProxyFactory
implements ProxyFactory {
    private static final Logger log = Logger.getLogger(BaseSessionProxyFactory.class);
    protected Container container;
    protected Advisor advisor;

    public void setContainer(Container container) {
        this.container = container;
        this.advisor = (Advisor)container;
    }

    protected void setEjb21Objects(BaseSessionRemoteProxy proxy) {
        proxy.setHandle(this.getHandle());
        proxy.setHomeHandle(this.getHomeHandle());
        proxy.setEjbMetaData(this.getEjbMetaData());
    }

    protected abstract Handle getHandle();

    protected HomeHandle getHomeHandle() {
        EJBContainer ejbContainer = (EJBContainer)this.container;
        HomeHandleImpl homeHandle = null;
        RemoteBinding remoteBindingAnnotation = (RemoteBinding)ejbContainer.resolveAnnotation(RemoteBinding.class);
        if (remoteBindingAnnotation != null) {
            homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding());
        }
        return homeHandle;
    }

    protected EJBMetaData getEjbMetaData() {
        RemoteBinding remoteBindingAnnotation;
        RemoteHome homeAnnotation;
        Class remote = null;
        Class home = null;
        Class<Object> pkClass = Object.class;
        HomeHandleImpl homeHandle = null;
        EJBContainer ejbContainer = (EJBContainer)this.container;
        Remote remoteAnnotation = (Remote)ejbContainer.resolveAnnotation(Remote.class);
        if (remoteAnnotation != null) {
            remote = remoteAnnotation.value()[0];
        }
        if ((homeAnnotation = (RemoteHome)ejbContainer.resolveAnnotation(RemoteHome.class)) != null) {
            home = homeAnnotation.value();
        }
        if ((remoteBindingAnnotation = (RemoteBinding)ejbContainer.resolveAnnotation(RemoteBinding.class)) != null) {
            homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding());
        }
        EJBMetaDataImpl metadata = new EJBMetaDataImpl(remote, home, pkClass, true, false, (HomeHandle)homeHandle);
        return metadata;
    }
}

