/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.alarm;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.alarm.TimeDrivenActivity;
import org.jbpm.bpel.sublang.def.Expression;
import org.jbpm.bpel.xml.util.DatatypeUtil;
import org.jbpm.bpel.xml.util.Duration;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Timer;
import org.jbpm.scheduler.SchedulerService;

public class AlarmAction
extends Action {
    private Expression _for;
    private Expression until;
    private Expression repeatEvery;
    private TimeDrivenActivity timeDrivenActivity;
    private static Log log = LogFactory.getLog((Class)AlarmAction.class);
    private static final String ALARM_NAME = "a:";
    private static final long serialVersionUID = 1L;

    public void createTimer(Token token, SchedulerService scheduler) {
        Calendar dueDate;
        Timer timer = new Timer(token);
        timer.setName(ALARM_NAME + this.getId());
        timer.setAction((Action)this);
        if (this.until != null) {
            dueDate = DatatypeUtil.toDateTime(this.until.getEvaluator().evaluate(token));
        } else if (this._for != null) {
            Duration dueDuration = DatatypeUtil.toDuration(this._for.getEvaluator().evaluate(token));
            dueDate = Calendar.getInstance();
            dueDuration.addTo(dueDate);
        } else {
            throw new BpelException("neither until nor for specified for alarm: " + (Object)((Object)this));
        }
        long dueDateMs = dueDate.getTimeInMillis();
        timer.setDueDate(new Date(dueDateMs));
        if (this.repeatEvery != null) {
            Duration repeatDuration = DatatypeUtil.toDuration(this.repeatEvery.getEvaluator().evaluate(token));
            long repeatDurationMs = repeatDuration.getTimeInMillis();
            timer.setRepeat(repeatDurationMs / 1000L + " seconds");
        }
        scheduler.createTimer(timer);
        log.debug((Object)("created timer: alarm=" + (Object)((Object)this) + ", token=" + token));
    }

    public void execute(ExecutionContext exeContext) throws Exception {
        if (exeContext.getTimer() == null) {
            this.createTimer(exeContext.getToken(), AlarmAction.getSchedulerService(exeContext.getJbpmContext()));
        } else {
            this.timeDrivenActivity.alarmFired(this, exeContext.getToken());
        }
    }

    public void deleteTimer(Token token, SchedulerService scheduler) {
        scheduler.deleteTimersByName(ALARM_NAME + this.getId(), token);
        log.debug((Object)("deleted timer: alarm=" + (Object)((Object)this) + ", token=" + token));
    }

    public static SchedulerService getSchedulerService(JbpmContext jbpmContext) {
        return jbpmContext.getServices().getSchedulerService();
    }

    public Expression getFor() {
        return this._for;
    }

    public void setFor(Expression _for) {
        this._for = _for;
    }

    public Expression getUntil() {
        return this.until;
    }

    public void setUntil(Expression until) {
        this.until = until;
    }

    public Expression getRepeatEvery() {
        return this.repeatEvery;
    }

    public void setRepeatEvery(Expression repeatEvery) {
        this.repeatEvery = repeatEvery;
    }

    public TimeDrivenActivity getTimeDrivenActivity() {
        return this.timeDrivenActivity;
    }

    public void setTimeDrivenActivity(TimeDrivenActivity timeDrivenActivity) {
        this.timeDrivenActivity = timeDrivenActivity;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        if (this._for != null) {
            builder.append("for", (Object)this._for.getText());
        } else if (this.until != null) {
            builder.append("until", (Object)this.until.getText());
        }
        if (this.repeatEvery != null) {
            builder.append("repeatEvery", (Object)this.repeatEvery.getText());
        }
        return builder.toString();
    }
}

