/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.processor.util;

import com.sun.mirror.apt.Filer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.jboss.com.sun.tools.ws.processor.util.ProcessorEnvironment;

public abstract class ProcessorEnvironmentBase
implements ProcessorEnvironment {
    protected URLClassLoader classLoader = null;
    protected Filer filer = null;

    public URLClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new URLClassLoader(ProcessorEnvironmentBase.pathToURLs(this.getClassPath()), this.getClass().getClassLoader());
        }
        return this.classLoader;
    }

    public static URL[] pathToURLs(String path) {
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        URL[] urls = new URL[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            URL url = ProcessorEnvironmentBase.fileToURL(new File(st.nextToken()));
            if (url == null) continue;
            urls[count++] = url;
        }
        if (urls.length != count) {
            URL[] tmp = new URL[count];
            System.arraycopy(urls, 0, tmp, 0, count);
            urls = tmp;
        }
        return urls;
    }

    public static URL fileToURL(File file) {
        String name;
        try {
            name = file.getCanonicalPath();
        }
        catch (IOException e) {
            name = file.getAbsolutePath();
        }
        name = name.replace(File.separatorChar, '/');
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (!file.isFile()) {
            name = name + "/";
        }
        try {
            return new URL("file", "", name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("file");
        }
    }

    public Filer getFiler() {
        return this.filer;
    }

    public void setFiler(Filer filer) {
        this.filer = filer;
    }
}

