/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.protocol.soap.server;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.com.sun.xml.messaging.saaj.soap.MessageImpl;
import org.jboss.com.sun.xml.ws.binding.BindingImpl;
import org.jboss.com.sun.xml.ws.binding.soap.SOAPBindingImpl;
import org.jboss.com.sun.xml.ws.encoding.JAXWSAttachmentMarshaller;
import org.jboss.com.sun.xml.ws.encoding.soap.SOAPConstants;
import org.jboss.com.sun.xml.ws.encoding.soap.SOAPDecoder;
import org.jboss.com.sun.xml.ws.encoding.soap.SOAPEPTFactory;
import org.jboss.com.sun.xml.ws.encoding.soap.SOAPEncoder;
import org.jboss.com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import org.jboss.com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import org.jboss.com.sun.xml.ws.handler.HandlerChainCaller;
import org.jboss.com.sun.xml.ws.handler.MessageContextUtil;
import org.jboss.com.sun.xml.ws.handler.SOAPHandlerContext;
import org.jboss.com.sun.xml.ws.model.soap.SOAPRuntimeModel;
import org.jboss.com.sun.xml.ws.pept.ept.MessageInfo;
import org.jboss.com.sun.xml.ws.pept.presentation.TargetFinder;
import org.jboss.com.sun.xml.ws.pept.presentation.Tie;
import org.jboss.com.sun.xml.ws.pept.protocol.MessageDispatcher;
import org.jboss.com.sun.xml.ws.server.AppMsgContextImpl;
import org.jboss.com.sun.xml.ws.server.RuntimeContext;
import org.jboss.com.sun.xml.ws.server.RuntimeEndpointInfo;
import org.jboss.com.sun.xml.ws.server.ServerRtException;
import org.jboss.com.sun.xml.ws.spi.runtime.Binding;
import org.jboss.com.sun.xml.ws.spi.runtime.Invoker;
import org.jboss.com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;
import org.jboss.com.sun.xml.ws.spi.runtime.WSConnection;
import org.jboss.com.sun.xml.ws.spi.runtime.WebServiceContext;
import org.jboss.com.sun.xml.ws.util.FastInfosetUtil;
import org.jboss.com.sun.xml.ws.util.MessageInfoUtil;
import org.jboss.com.sun.xml.ws.util.SOAPConnectionUtil;

public class SOAPMessageDispatcher
implements MessageDispatcher {
    private static final String[] contentTypes = new String[]{"text/xml", "application/soap+xml", "application/xop+xml", "application/fastinfoset", "application/soap+fastinfoset"};
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.soapmd");

    public void send(MessageInfo messageInfo) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(MessageInfo messageInfo) {
        boolean sent;
        block21: {
            try {
                this.checkContentType(messageInfo);
            }
            catch (ServerRtException e) {
                SOAPConnectionUtil.sendKnownError(messageInfo, 415);
                return;
            }
            SOAPMessage soapMessage = null;
            try {
                soapMessage = this.getSOAPMessage(messageInfo);
            }
            catch (Exception e) {
                this.sendResponseError(messageInfo, e);
                return;
            }
            sent = false;
            try {
                try {
                    if (((MessageImpl)soapMessage).acceptFastInfoset()) {
                        messageInfo.setMetaData("com.sun.xml.ws.client.ContentNegotiation", "optimistic");
                    }
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
                SOAPHandlerContext context = new SOAPHandlerContext(messageInfo, null, soapMessage);
                this.updateHandlerContext(messageInfo, context);
                context.getMessageContext().put((Object)"javax.xml.ws.handler.message.outbound", (Object)Boolean.FALSE);
                MessageContext msgCtxt = MessageInfoUtil.getMessageContext(messageInfo);
                if (msgCtxt != null) {
                    MessageContextUtil.copyInboundMessageAttachments(msgCtxt, soapMessage.getAttachments());
                }
                SystemHandlerDelegate shd = this.getSystemHandlerDelegate(messageInfo);
                SoapInvoker implementor = new SoapInvoker(messageInfo, soapMessage, context, shd);
                try {
                    if (shd == null) {
                        implementor.invoke();
                    } else {
                        context.setInvoker(implementor);
                        if (shd.processRequest(context.getSHDSOAPMessageContext())) {
                            implementor.invoke();
                            context.getMessageContext().put((Object)"javax.xml.ws.handler.message.outbound", (Object)Boolean.TRUE);
                            shd.processResponse(context.getSHDSOAPMessageContext());
                        }
                    }
                }
                finally {
                    sent = implementor.isSent();
                }
                if (!SOAPMessageDispatcher.isOneway(messageInfo)) {
                    this.makeSOAPMessage(messageInfo, context);
                    sent = true;
                    this.sendResponse(messageInfo, context);
                } else if (!sent) {
                    sent = true;
                    this.sendResponseOneway(messageInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.SEVERE, e.getMessage(), e);
                if (sent) break block21;
                this.sendResponseError(messageInfo, e);
            }
        }
        assert (sent);
    }

    protected void toMessageInfo(MessageInfo messageInfo, SOAPHandlerContext context) {
        InternalMessage internalMessage = context.getInternalMessage();
        try {
            SOAPDecoder decoder;
            SOAPEPTFactory eptf;
            SOAPMessage soapMessage = context.getSOAPMessage();
            if (internalMessage == null) {
                eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                decoder = eptf.getSOAPDecoder();
                internalMessage = decoder.toInternalMessage(soapMessage, messageInfo);
            } else {
                eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                decoder = eptf.getSOAPDecoder();
                internalMessage = decoder.toInternalMessage(soapMessage, internalMessage, messageInfo);
            }
            eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
            SOAPEncoder encoder = eptf.getSOAPEncoder();
            encoder.setAttachmentsMap(messageInfo, internalMessage);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            messageInfo.setResponseType(2);
            messageInfo.setResponse(e);
        }
        if (!SOAPMessageDispatcher.isFailure(messageInfo)) {
            String bindingId;
            SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
            eptf.getInternalEncoder().toMessageInfo(internalMessage, messageInfo);
            Binding binding = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo().getBinding();
            String string = bindingId = binding != null ? ((SOAPBindingImpl)binding).getBindingId() : "http://schemas.xmlsoap.org/wsdl/soap/http";
            if (messageInfo.getMethod() == null) {
                messageInfo.setResponseType(2);
                SOAPFaultInfo faultInfo = new SOAPFaultInfo("Cannot find dispatch method", SOAPConstants.FAULT_CODE_SERVER, null, null, bindingId);
                messageInfo.setResponse(faultInfo);
            }
        }
    }

    private SOAPMessage getSOAPMessage(MessageInfo messageInfo) {
        WSConnection con = messageInfo.getConnection();
        return SOAPConnectionUtil.getSOAPMessage(con, messageInfo, null);
    }

    private void checkContentType(MessageInfo mi) {
        WSConnection con = mi.getConnection();
        Map<String, List<String>> headers = con.getHeaders();
        List<String> cts = headers.get("Content-Type");
        if (cts != null && cts.size() > 0) {
            String ct = cts.get(0);
            for (String contentType : contentTypes) {
                if (ct.indexOf(contentType) == -1) continue;
                return;
            }
        }
        throw new ServerRtException("Incorrect Content-Type=" + cts, new Object[0]);
    }

    protected void updateWebServiceContext(MessageInfo messageInfo, SOAPHandlerContext hc) {
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeEndpointInfo endpointInfo = rtCtxt.getRuntimeEndpointInfo();
        WebServiceContext wsContext = endpointInfo.getWebServiceContext();
        hc.getMessageContext().put((Object)"com.sun.xml.ws.client.ContentNegotiation", messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation"));
        hc.getMessageContext().setScope("com.sun.xml.ws.client.ContentNegotiation", MessageContext.Scope.APPLICATION);
        if (wsContext != null) {
            AppMsgContextImpl appCtxt = new AppMsgContextImpl(hc.getMessageContext());
            wsContext.setMessageContext(appCtxt);
        }
    }

    protected void invokeEndpoint(MessageInfo messageInfo, SOAPHandlerContext hc) {
        TargetFinder targetFinder = messageInfo.getEPTFactory().getTargetFinder(messageInfo);
        Tie tie = targetFinder.findTarget(messageInfo);
        tie._invoke(messageInfo);
    }

    protected void getResponse(MessageInfo messageInfo, SOAPHandlerContext context) {
        this.setResponseInContext(messageInfo, context);
        try {
            HandlerChainCaller handlerCaller = this.getCallerFromMessageInfo(messageInfo);
            if (handlerCaller != null && handlerCaller.hasHandlers()) {
                int messageType = messageInfo.getResponseType();
                if (messageType == 1 || messageType == 2) {
                    this.callHandleFault(handlerCaller, context);
                } else {
                    JAXWSAttachmentMarshaller am = MessageInfoUtil.getAttachmentMarshaller(messageInfo);
                    boolean isXopped = false;
                    if (am != null && am.isXOPPackage()) {
                        isXopped = am.isXOPPackage();
                        am.setXOPPackage(false);
                    }
                    this.callHandlersOnResponse(handlerCaller, context);
                    if (am != null) {
                        am.setXOPPackage(isXopped);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            this.createInternalMessageForException(messageInfo, e, context);
        }
    }

    private boolean createInternalMessageForException(MessageInfo messageInfo, Exception e, SOAPHandlerContext context) {
        boolean soap12 = false;
        RuntimeEndpointInfo rei = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo();
        String id = ((SOAPBindingImpl)rei.getBinding()).getBindingId();
        InternalMessage internalMessage = null;
        if (id.equals("http://schemas.xmlsoap.org/wsdl/soap/http")) {
            internalMessage = SOAPRuntimeModel.createFaultInBody(e, null, null, null);
        } else if (id.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            internalMessage = SOAPRuntimeModel.createSOAP12FaultInBody(e, null, null, null, null);
            soap12 = true;
        }
        context.setInternalMessage(internalMessage);
        context.setSOAPMessage(null);
        return soap12;
    }

    private void makeSOAPMessage(MessageInfo messageInfo, SOAPHandlerContext context) {
        InternalMessage internalMessage = context.getInternalMessage();
        if (internalMessage != null) {
            SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
            SOAPEncoder encoder = eptf.getSOAPEncoder();
            SOAPMessage soapMesage = encoder.toSOAPMessage(internalMessage, messageInfo);
            context.setSOAPMessage(soapMesage);
            context.setInternalMessage(null);
        }
    }

    protected void setResponseInContext(MessageInfo messageInfo, SOAPHandlerContext context) {
        SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
        InternalMessage internalMessage = (InternalMessage)eptf.getInternalEncoder().toInternalMessage(messageInfo);
        context.setInternalMessage(internalMessage);
        context.setSOAPMessage(null);
    }

    private void sendResponse(MessageInfo messageInfo, SOAPHandlerContext ctxt) {
        SOAPMessage soapMessage = ctxt.getSOAPMessage();
        WSConnection con = messageInfo.getConnection();
        Integer status = MessageContextUtil.getHttpStatusCode(ctxt.getMessageContext());
        int statusCode = status == null ? 200 : status;
        SOAPConnectionUtil.setStatus(con, statusCode);
        SOAPConnectionUtil.sendResponse(con, soapMessage);
    }

    protected void sendResponseOneway(MessageInfo messageInfo) {
        SOAPConnectionUtil.sendResponseOneway(messageInfo);
    }

    private void sendResponseError(MessageInfo messageInfo, Exception e) {
        e.printStackTrace();
        WSConnection con = messageInfo.getConnection();
        Binding binding = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo().getBinding();
        String bindingId = ((SOAPBindingImpl)binding).getBindingId();
        SOAPConnectionUtil.sendResponseError(con, bindingId);
    }

    private boolean callHandlersOnRequest(MessageInfo messageInfo, SOAPHandlerContext context, boolean responseExpected) {
        boolean skipEndpoint = false;
        HandlerChainCaller handlerCaller = this.getCallerFromMessageInfo(messageInfo);
        if (handlerCaller != null && handlerCaller.hasHandlers()) {
            try {
                skipEndpoint = !handlerCaller.callHandlers(HandlerChainCaller.Direction.INBOUND, HandlerChainCaller.RequestOrResponse.REQUEST, context, responseExpected);
            }
            catch (ProtocolException pe) {
                skipEndpoint = true;
                if (MessageContextUtil.ignoreFaultInMessage(context.getMessageContext())) {
                    this.createInternalMessageForException(messageInfo, (Exception)((Object)pe), context);
                }
            }
            catch (RuntimeException re) {
                skipEndpoint = true;
                this.createInternalMessageForException(messageInfo, re, context);
            }
        }
        return skipEndpoint;
    }

    private HandlerChainCaller getCallerFromMessageInfo(MessageInfo info) {
        RuntimeContext context = (RuntimeContext)info.getMetaData("org.jboss.com.sun.xml.ws.runtime.context");
        BindingImpl binding = (BindingImpl)context.getRuntimeEndpointInfo().getBinding();
        if (binding.hasHandlers()) {
            HandlerChainCaller caller = binding.getHandlerChainCaller();
            MessageInfoUtil.setHandlerChainCaller(info, caller);
            return caller;
        }
        return null;
    }

    protected boolean callHandlersOnResponse(HandlerChainCaller caller, SOAPHandlerContext context) {
        return caller.callHandlers(HandlerChainCaller.Direction.OUTBOUND, HandlerChainCaller.RequestOrResponse.RESPONSE, context, false);
    }

    protected boolean callHandleFault(HandlerChainCaller caller, SOAPHandlerContext context) {
        return caller.callHandleFault(context);
    }

    private void closeHandlers(MessageInfo info, SOAPHandlerContext context) {
        HandlerChainCaller handlerCaller = this.getCallerFromMessageInfo(info);
        if (handlerCaller != null && handlerCaller.hasHandlers()) {
            handlerCaller.forceCloseHandlersOnServer(context);
        }
    }

    private static boolean isFailure(MessageInfo messageInfo) {
        return messageInfo.getResponseType() == 2;
    }

    public static boolean isOneway(MessageInfo messageInfo) {
        return messageInfo.getMEP() == 2;
    }

    private void updateHandlerContext(MessageInfo messageInfo, SOAPHandlerContext context) {
        MessageInfoUtil.getRuntimeContext(messageInfo).setHandlerContext(context);
        RuntimeEndpointInfo endpointInfo = MessageInfoUtil.getRuntimeContext(messageInfo).getRuntimeEndpointInfo();
        context.setBindingId(((BindingImpl)endpointInfo.getBinding()).getActualBindingId());
        WebServiceContext wsContext = endpointInfo.getWebServiceContext();
        if (wsContext != null) {
            context.setMessageContext(wsContext.getMessageContext());
        }
    }

    private SystemHandlerDelegate getSystemHandlerDelegate(MessageInfo mi) {
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(mi);
        RuntimeEndpointInfo endpointInfo = rtCtxt.getRuntimeEndpointInfo();
        return endpointInfo.getBinding().getSystemHandlerDelegate();
    }

    private class SoapInvoker
    implements Invoker {
        MessageInfo messageInfo;
        SOAPMessage soapMessage;
        SOAPHandlerContext context;
        boolean skipEndpoint;
        SystemHandlerDelegate shd;
        boolean sent;

        SoapInvoker(MessageInfo messageInfo, SOAPMessage soapMessage, SOAPHandlerContext context, SystemHandlerDelegate shd) {
            this.messageInfo = messageInfo;
            this.soapMessage = soapMessage;
            this.context = context;
            this.shd = shd;
        }

        public void invoke() throws Exception {
            boolean peekOneWay = false;
            if (!this.skipEndpoint) {
                try {
                    SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)this.messageInfo.getEPTFactory());
                    SOAPDecoder decoder = eptf.getSOAPDecoder();
                    SOAPMessageDispatcher.this.getCallerFromMessageInfo(this.messageInfo);
                    peekOneWay = decoder.doMustUnderstandProcessing(this.soapMessage, this.messageInfo, this.context, true);
                    this.context.setMethod(this.messageInfo.getMethod());
                }
                catch (SOAPFaultException e) {
                    this.skipEndpoint = true;
                    boolean soap12 = SOAPMessageDispatcher.this.createInternalMessageForException(this.messageInfo, (Exception)((Object)e), this.context);
                    SOAPRuntimeModel.addHeaders(this.context.getInternalMessage(), this.messageInfo);
                }
            }
            if (!this.skipEndpoint) {
                this.skipEndpoint = SOAPMessageDispatcher.this.callHandlersOnRequest(this.messageInfo, this.context, !peekOneWay);
            }
            if (this.skipEndpoint) {
                this.soapMessage = this.context.getSOAPMessage();
                if (this.soapMessage == null) {
                    InternalMessage internalMessage = this.context.getInternalMessage();
                    SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)this.messageInfo.getEPTFactory());
                    SOAPEncoder encoder = eptf.getSOAPEncoder();
                    this.soapMessage = encoder.toSOAPMessage(internalMessage, this.messageInfo);
                }
                FastInfosetUtil.ensureCorrectEncoding(this.messageInfo, this.soapMessage);
                this.context.setSOAPMessage(this.soapMessage);
                this.context.setInternalMessage(null);
            } else {
                SOAPMessageDispatcher.this.toMessageInfo(this.messageInfo, this.context);
                if (SOAPMessageDispatcher.isOneway(this.messageInfo)) {
                    this.sent = true;
                    SOAPMessageDispatcher.this.sendResponseOneway(this.messageInfo);
                    if (!peekOneWay) {
                        SOAPMessageDispatcher.this.closeHandlers(this.messageInfo, this.context);
                    }
                }
                if (!SOAPMessageDispatcher.isFailure(this.messageInfo)) {
                    if (this.shd != null) {
                        this.shd.preInvokeEndpointHook(this.context.getSHDSOAPMessageContext());
                    }
                    SOAPMessageDispatcher.this.updateWebServiceContext(this.messageInfo, this.context);
                    SOAPMessageDispatcher.this.invokeEndpoint(this.messageInfo, this.context);
                    if (!this.sent && SOAPMessageDispatcher.isOneway(this.messageInfo)) {
                        this.sent = true;
                        SOAPMessageDispatcher.this.sendResponseOneway(this.messageInfo);
                    }
                    this.context.getMessageContext().put((Object)"javax.xml.ws.handler.message.outbound", (Object)Boolean.TRUE);
                }
                if (SOAPMessageDispatcher.isOneway(this.messageInfo)) {
                    if (SOAPMessageDispatcher.isFailure(this.messageInfo)) {
                        // empty if block
                    }
                } else {
                    SOAPMessageDispatcher.this.getResponse(this.messageInfo, this.context);
                }
            }
        }

        public Method getMethod(QName name) {
            RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(this.messageInfo);
            return rtCtxt.getDispatchMethod(name, this.messageInfo);
        }

        public boolean isSent() {
            return this.sent;
        }
    }
}

