/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.crypto;

import com.pointbase.crypto.cryptoBlockCipher;
import com.pointbase.crypto.cryptoCbcBlockCipher;
import com.pointbase.crypto.cryptoCipher;
import com.pointbase.crypto.cryptoStreamCipher;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class cryptoEncryptedOutputStream
extends FilterOutputStream {
    private cryptoBlockCipher m_blockCipher = null;
    private cryptoStreamCipher m_streamCipher = null;
    private cryptoCipher m_cipher;
    private cryptoCbcBlockCipher m_cbcBlockCipher;
    private int m_blockSize;
    private int m_cryptoSize;
    private byte[] m_clearText;
    private byte[] m_cipherText;
    private int m_byteCount;
    private boolean m_encrypting = true;

    public cryptoEncryptedOutputStream(cryptoBlockCipher cryptoBlockCipher2, OutputStream outputStream) throws IOException {
        super(outputStream);
        this.m_blockCipher = cryptoBlockCipher2;
        this.m_blockSize = this.m_blockCipher.blockSize();
        this.m_cbcBlockCipher = new cryptoCbcBlockCipher(this.m_blockCipher);
        this.m_cryptoSize = this.m_blockSize;
        this.m_clearText = new byte[this.m_blockSize];
        this.m_cipherText = new byte[this.m_blockSize];
        this.m_byteCount = 0;
        this.m_cipher = this.m_blockCipher;
        outputStream.write(this.m_cbcBlockCipher.setRandomIv(), 0, this.m_blockSize);
    }

    public cryptoEncryptedOutputStream(cryptoStreamCipher cryptoStreamCipher2, OutputStream outputStream) {
        super(outputStream);
        this.m_streamCipher = cryptoStreamCipher2;
        this.m_blockSize = 1;
        this.m_cipher = this.m_streamCipher;
    }

    public void setKey(String string) {
        this.m_cipher.setKey(string);
    }

    public void setEncrypting(boolean bl) throws IOException {
        if (this.m_encrypting && !bl) {
            this.flush();
        }
        this.m_encrypting = bl;
    }

    private void sendBlock() throws IOException {
        int n = this.m_byteCount;
        while (n < this.m_cryptoSize) {
            this.m_clearText[n] = (byte)(Math.random() * 256.0);
            ++n;
        }
        this.m_cbcBlockCipher.encrypt(this.m_clearText, 0, this.m_cipherText, 0);
        this.out.write(this.m_cipherText, 0, this.m_blockSize);
        this.out.write((byte)this.m_byteCount);
        this.m_byteCount = 0;
    }

    public void write(int n) throws IOException {
        if (this.m_encrypting) {
            if (this.m_blockCipher != null) {
                this.m_clearText[this.m_byteCount++] = (byte)n;
                if (this.m_byteCount >= this.m_cryptoSize) {
                    this.sendBlock();
                }
            } else {
                this.out.write(this.m_streamCipher.encrypt((byte)n));
            }
        } else {
            this.out.write(n);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.m_encrypting) {
            if (this.m_blockCipher != null) {
                int n3 = n;
                while (n3 < n + n2) {
                    this.m_clearText[this.m_byteCount++] = byArray[n3];
                    if (this.m_byteCount >= this.m_cryptoSize) {
                        this.sendBlock();
                    }
                    ++n3;
                }
            } else {
                byte[] byArray2 = new byte[n2];
                this.m_streamCipher.encrypt(byArray, n, byArray2, 0, n2);
                this.out.write(byArray2, 0, n2);
            }
        } else {
            this.out.write(byArray, n, n2);
        }
    }

    public void flush() throws IOException {
        if (this.m_encrypting && this.m_blockCipher != null && this.m_byteCount != 0) {
            this.sendBlock();
        }
        this.out.flush();
    }
}

