/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryEvent;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.component.repository.ComponentSetDescriptor;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class MavenPluginCollector
extends AbstractLogEnabled
implements ComponentDiscoveryListener {
    private Set pluginsInProcess = new HashSet();
    private Map pluginDescriptors = new HashMap();
    private Map pluginIdsByPrefix = new HashMap();

    public void componentDiscovered(ComponentDiscoveryEvent event) {
        PluginDescriptor pluginDescriptor;
        String key;
        ComponentSetDescriptor componentSetDescriptor = event.getComponentSetDescriptor();
        if (componentSetDescriptor instanceof PluginDescriptor && !this.pluginsInProcess.contains(key = Plugin.constructKey((String)(pluginDescriptor = (PluginDescriptor)componentSetDescriptor).getGroupId(), (String)pluginDescriptor.getArtifactId()))) {
            this.pluginsInProcess.add(key);
            this.pluginDescriptors.put(key, pluginDescriptor);
            if (!this.pluginIdsByPrefix.containsKey(pluginDescriptor.getGoalPrefix())) {
                this.pluginIdsByPrefix.put(pluginDescriptor.getGoalPrefix(), pluginDescriptor);
            }
        }
    }

    public PluginDescriptor getPluginDescriptor(Plugin plugin) {
        return (PluginDescriptor)this.pluginDescriptors.get(plugin.getKey());
    }

    public boolean isPluginInstalled(Plugin plugin) {
        return this.pluginDescriptors.containsKey(plugin.getKey());
    }

    public PluginDescriptor getPluginDescriptorForPrefix(String prefix) {
        return (PluginDescriptor)this.pluginIdsByPrefix.get(prefix);
    }

    public void flushPluginDescriptor(Plugin plugin) {
        this.pluginsInProcess.remove(plugin.getKey());
        this.pluginDescriptors.remove(plugin.getKey());
        Iterator it = this.pluginIdsByPrefix.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!plugin.getKey().equals(entry.getValue())) continue;
            it.remove();
        }
    }
}

