/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class WebSecurityMetaData {
    public static final Set ALL_HTTP_METHODS;
    public static final String[] ALL_HTTP_METHOD_NAMES;
    private HashMap webResources = new HashMap();
    private Set roles = new HashSet();
    private String transportGuarantee;
    private boolean unchecked = false;
    private boolean excluded = false;

    public static String[] getMissingHttpMethods(HashSet httpMethods) {
        String[] methods = new String[]{};
        if (httpMethods.size() > 0 && !httpMethods.containsAll(ALL_HTTP_METHODS)) {
            HashSet missingMethods = new HashSet(ALL_HTTP_METHODS);
            missingMethods.removeAll(httpMethods);
            methods = new String[missingMethods.size()];
            missingMethods.toArray(methods);
        }
        return methods;
    }

    public WebResourceCollection addWebResource(String name) {
        WebResourceCollection webrc = new WebResourceCollection(name);
        if (this.webResources.containsKey(name)) {
            name = name + '@' + System.identityHashCode(webrc);
        }
        this.webResources.put(name, webrc);
        return webrc;
    }

    public HashMap getWebResources() {
        return this.webResources;
    }

    public void addRole(String name) {
        this.roles.add(name);
    }

    public Set getRoles() {
        return this.roles;
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public void setTransportGuarantee(String transportGuarantee) {
        this.transportGuarantee = transportGuarantee;
    }

    public boolean isUnchecked() {
        return this.unchecked;
    }

    public void setUnchecked(boolean flag) {
        this.unchecked = flag;
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public void setExcluded(boolean flag) {
        this.excluded = flag;
    }

    static {
        TreeSet<String> tmp = new TreeSet<String>();
        tmp.add("GET");
        tmp.add("POST");
        tmp.add("PUT");
        tmp.add("DELETE");
        tmp.add("HEAD");
        tmp.add("OPTIONS");
        tmp.add("TRACE");
        ALL_HTTP_METHODS = Collections.unmodifiableSortedSet(tmp);
        ALL_HTTP_METHOD_NAMES = new String[ALL_HTTP_METHODS.size()];
        ALL_HTTP_METHODS.toArray(ALL_HTTP_METHOD_NAMES);
    }

    public static class WebResourceCollection {
        private String name;
        private HashSet urlPatterns = new HashSet();
        private ArrayList httpMethods = new ArrayList();

        public WebResourceCollection(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addPattern(String pattern) {
            this.urlPatterns.add(pattern);
        }

        public String[] getUrlPatterns() {
            String[] patterns = new String[]{};
            patterns = new String[this.urlPatterns.size()];
            this.urlPatterns.toArray(patterns);
            return patterns;
        }

        public void addHttpMethod(String method) {
            this.httpMethods.add(method);
        }

        public String[] getHttpMethods() {
            String[] methods = new String[]{};
            if (!this.httpMethods.containsAll(ALL_HTTP_METHODS)) {
                methods = new String[this.httpMethods.size()];
                this.httpMethods.toArray(methods);
            }
            return methods;
        }

        public String[] getMissingHttpMethods() {
            String[] methods = new String[]{};
            if (this.httpMethods.size() > 0 && !this.httpMethods.containsAll(ALL_HTTP_METHODS)) {
                HashSet missingMethods = new HashSet(ALL_HTTP_METHODS);
                missingMethods.removeAll(this.httpMethods);
                methods = new String[missingMethods.size()];
                missingMethods.toArray(methods);
            }
            return methods;
        }
    }
}

