/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.acessor;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.bind.api.RawAccessor;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.umdm.Accessor;
import org.jboss.ws.metadata.umdm.AccessorFactory;
import org.jboss.ws.metadata.umdm.AccessorFactoryCreator;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;

public class JAXBAccessor
implements Accessor {
    private RawAccessor accessor;
    public static AccessorFactoryCreator FACTORY_CREATOR = new AccessorFactoryCreator(){

        public AccessorFactory create(ParameterMetaData parameter) {
            return this.create(parameter.getJavaType());
        }

        public AccessorFactory create(FaultMetaData fault) {
            return this.create(fault.getFaultBean());
        }

        private AccessorFactory create(final Class clazz) {
            JAXBRIContext ctx;
            try {
                ctx = (JAXBRIContext)JAXBRIContext.newInstance((Class[])new Class[]{clazz});
            }
            catch (JAXBException e) {
                WSException ex = new WSException(e.getMessage());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
            return new AccessorFactory(){

                public Accessor create(WrappedParameter parameter) {
                    RawAccessor accessor;
                    try {
                        QName name = parameter.getName();
                        accessor = ctx.getElementPropertyAccessor(clazz, name.getNamespaceURI().intern(), name.getLocalPart().intern());
                    }
                    catch (Throwable t) {
                        WSException ex = new WSException(t.getMessage());
                        ex.setStackTrace(t.getStackTrace());
                        throw ex;
                    }
                    if (accessor == null) {
                        throw new IllegalStateException("Could not obtain accessor for parameter: " + parameter);
                    }
                    return new JAXBAccessor(accessor);
                }
            };
        }
    };

    private JAXBAccessor(RawAccessor accessor) {
        this.accessor = accessor;
    }

    public Object get(Object bean) {
        try {
            return this.accessor.get(bean);
        }
        catch (AccessorException a) {
            WSException ex = new WSException(a.getMessage());
            ex.setStackTrace(a.getStackTrace());
            throw ex;
        }
    }

    public void set(Object bean, Object value) {
        try {
            this.accessor.set(bean, value);
        }
        catch (AccessorException a) {
            WSException ex = new WSException(a.getMessage());
            ex.setStackTrace(a.getStackTrace());
            throw ex;
        }
    }
}

