/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import junit.framework.Assert;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.FileUploadTestCase;
import org.apache.commons.fileupload.HttpServletRequestFactory;

public class ServletFileUploadTest
extends FileUploadTestCase {
    public void testWithInvalidRequest() {
        DiskFileUpload fu = null;
        fu = new DiskFileUpload();
        HttpServletRequest req = HttpServletRequestFactory.createInvalidHttpServletRequest();
        try {
            fu.parseRequest(req);
            Assert.fail((String)"testWithInvalidRequest: expected exception was not thrown");
        }
        catch (FileUploadException fileUploadException) {
            // empty catch block
        }
    }

    public void testWithNullContentType() {
        DiskFileUpload fu = new DiskFileUpload();
        HttpServletRequest req = HttpServletRequestFactory.createHttpServletRequestWithNullContentType();
        try {
            fu.parseRequest(req);
            Assert.fail((String)"testWithNullContentType: expected exception was not thrown");
        }
        catch (FileUploadBase.InvalidContentTypeException invalidContentTypeException) {
        }
        catch (FileUploadException unexpected) {
            Assert.fail((String)"testWithNullContentType: unexpected exception was thrown");
        }
    }

    public void testFileUpload() throws IOException, FileUploadException {
        List fileItems = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n");
        Assert.assertEquals((int)4, (int)fileItems.size());
        FileItem file = (FileItem)fileItems.get(0);
        Assert.assertEquals((String)"file", (String)file.getFieldName());
        Assert.assertFalse((boolean)file.isFormField());
        Assert.assertEquals((String)"This is the content of the file\n", (String)file.getString());
        Assert.assertEquals((String)"text/whatever", (String)file.getContentType());
        Assert.assertEquals((String)"foo.tab", (String)file.getName());
        FileItem field = (FileItem)fileItems.get(1);
        Assert.assertEquals((String)"field", (String)field.getFieldName());
        Assert.assertTrue((boolean)field.isFormField());
        Assert.assertEquals((String)"fieldValue", (String)field.getString());
        FileItem multi0 = (FileItem)fileItems.get(2);
        Assert.assertEquals((String)"multi", (String)multi0.getFieldName());
        Assert.assertTrue((boolean)multi0.isFormField());
        Assert.assertEquals((String)"value1", (String)multi0.getString());
        FileItem multi1 = (FileItem)fileItems.get(3);
        Assert.assertEquals((String)"multi", (String)multi1.getFieldName());
        Assert.assertTrue((boolean)multi1.isFormField());
        Assert.assertEquals((String)"value2", (String)multi1.getString());
    }

    public void testFilenameCaseSensitivity() throws IOException, FileUploadException {
        List fileItems = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"FiLe\"; filename=\"FOO.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234--\r\n");
        Assert.assertEquals((int)1, (int)fileItems.size());
        FileItem file = (FileItem)fileItems.get(0);
        Assert.assertEquals((String)"FiLe", (String)file.getFieldName());
        Assert.assertEquals((String)"FOO.tab", (String)file.getName());
    }

    public void testEmptyFile() throws UnsupportedEncodingException, FileUploadException {
        List fileItems = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"\"\r\n\r\n\r\n-----1234--\r\n");
        Assert.assertEquals((int)1, (int)fileItems.size());
        FileItem file = (FileItem)fileItems.get(0);
        Assert.assertFalse((boolean)file.isFormField());
        Assert.assertEquals((String)"", (String)file.getString());
        Assert.assertEquals((String)"", (String)file.getName());
    }

    public void testIE5MacBug() throws UnsupportedEncodingException, FileUploadException {
        List fileItems = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"field1\"\r\n\r\nfieldValue\r\n-----1234\nContent-Disposition: form-data; name=\"submitName.x\"\r\n\r\n42\r\n-----1234\nContent-Disposition: form-data; name=\"submitName.y\"\r\n\r\n21\r\n-----1234\r\nContent-Disposition: form-data; name=\"field2\"\r\n\r\nfieldValue2\r\n-----1234--\r\n");
        Assert.assertEquals((int)4, (int)fileItems.size());
        FileItem field1 = (FileItem)fileItems.get(0);
        Assert.assertEquals((String)"field1", (String)field1.getFieldName());
        Assert.assertTrue((boolean)field1.isFormField());
        Assert.assertEquals((String)"fieldValue", (String)field1.getString());
        FileItem submitX = (FileItem)fileItems.get(1);
        Assert.assertEquals((String)"submitName.x", (String)submitX.getFieldName());
        Assert.assertTrue((boolean)submitX.isFormField());
        Assert.assertEquals((String)"42", (String)submitX.getString());
        FileItem submitY = (FileItem)fileItems.get(2);
        Assert.assertEquals((String)"submitName.y", (String)submitY.getFieldName());
        Assert.assertTrue((boolean)submitY.isFormField());
        Assert.assertEquals((String)"21", (String)submitY.getString());
        FileItem field2 = (FileItem)fileItems.get(3);
        Assert.assertEquals((String)"field2", (String)field2.getFieldName());
        Assert.assertTrue((boolean)field2.isFormField());
        Assert.assertEquals((String)"fieldValue2", (String)field2.getString());
    }

    public void testFILEUPLOAD62() throws Exception {
        String contentType = "multipart/form-data; boundary=AaB03x";
        String request = "--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"pics\"\r\nContent-type: multipart/mixed; boundary=BbC04y\r\n\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file1.txt\"\r\nContent-Type: text/plain\r\n\r\n... contents of file1.txt ...\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file2.gif\"\r\nContent-type: image/gif\r\nContent-Transfer-Encoding: binary\r\n\r\n...contents of file2.gif...\r\n--BbC04y--\r\n--AaB03x--";
        List fileItems = this.parseUpload("--AaB03x\r\ncontent-disposition: form-data; name=\"field1\"\r\n\r\nJoe Blow\r\n--AaB03x\r\ncontent-disposition: form-data; name=\"pics\"\r\nContent-type: multipart/mixed; boundary=BbC04y\r\n\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file1.txt\"\r\nContent-Type: text/plain\r\n\r\n... contents of file1.txt ...\r\n--BbC04y\r\nContent-disposition: attachment; filename=\"file2.gif\"\r\nContent-type: image/gif\r\nContent-Transfer-Encoding: binary\r\n\r\n...contents of file2.gif...\r\n--BbC04y--\r\n--AaB03x--".getBytes("US-ASCII"), "multipart/form-data; boundary=AaB03x");
        Assert.assertEquals((int)3, (int)fileItems.size());
        FileItem item0 = (FileItem)fileItems.get(0);
        Assert.assertEquals((String)"field1", (String)item0.getFieldName());
        Assert.assertNull((Object)item0.getName());
        Assert.assertEquals((String)"Joe Blow", (String)new String(item0.get()));
        FileItem item1 = (FileItem)fileItems.get(1);
        Assert.assertEquals((String)"pics", (String)item1.getFieldName());
        Assert.assertEquals((String)"file1.txt", (String)item1.getName());
        Assert.assertEquals((String)"... contents of file1.txt ...", (String)new String(item1.get()));
        FileItem item2 = (FileItem)fileItems.get(2);
        Assert.assertEquals((String)"pics", (String)item2.getFieldName());
        Assert.assertEquals((String)"file2.gif", (String)item2.getName());
        Assert.assertEquals((String)"...contents of file2.gif...", (String)new String(item2.get()));
    }

    public void testFoldedHeaders() throws IOException, FileUploadException {
        List fileItems = this.parseUpload("-----1234\r\nContent-Disposition: form-data; name=\"file\"; filename=\"foo.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; \r\n\tname=\"field\"\r\n\r\nfieldValue\r\n-----1234\r\nContent-Disposition: form-data;\r\n     name=\"multi\"\r\n\r\nvalue1\r\n-----1234\r\nContent-Disposition: form-data; name=\"multi\"\r\n\r\nvalue2\r\n-----1234--\r\n");
        Assert.assertEquals((int)4, (int)fileItems.size());
        FileItem file = (FileItem)fileItems.get(0);
        Assert.assertEquals((String)"file", (String)file.getFieldName());
        Assert.assertFalse((boolean)file.isFormField());
        Assert.assertEquals((String)"This is the content of the file\n", (String)file.getString());
        Assert.assertEquals((String)"text/whatever", (String)file.getContentType());
        Assert.assertEquals((String)"foo.tab", (String)file.getName());
        FileItem field = (FileItem)fileItems.get(1);
        Assert.assertEquals((String)"field", (String)field.getFieldName());
        Assert.assertTrue((boolean)field.isFormField());
        Assert.assertEquals((String)"fieldValue", (String)field.getString());
        FileItem multi0 = (FileItem)fileItems.get(2);
        Assert.assertEquals((String)"multi", (String)multi0.getFieldName());
        Assert.assertTrue((boolean)multi0.isFormField());
        Assert.assertEquals((String)"value1", (String)multi0.getString());
        FileItem multi1 = (FileItem)fileItems.get(3);
        Assert.assertEquals((String)"multi", (String)multi1.getFieldName());
        Assert.assertTrue((boolean)multi1.isFormField());
        Assert.assertEquals((String)"value2", (String)multi1.getString());
    }
}

