/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.factory;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.PageParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class BaseFactory
extends Factory {
    protected Config config = null;
    protected DecoratorMapper decoratorMapper = null;
    protected Map pageParsers = null;
    protected PageParser defaultPageParser = null;

    protected BaseFactory(Config config) {
        this.config = config;
        this.clearDecoratorMappers();
        this.clearParserMappings();
    }

    public DecoratorMapper getDecoratorMapper() {
        return this.decoratorMapper;
    }

    public PageParser getPageParser(String string) {
        if (this.pageParsers.containsKey(string)) {
            return (PageParser)this.pageParsers.get(string);
        }
        return this.defaultPageParser;
    }

    public boolean shouldParsePage(String string) {
        return this.pageParsers.containsKey(string);
    }

    protected void clearDecoratorMappers() {
        this.decoratorMapper = null;
    }

    protected void pushDecoratorMapper(String string, Properties properties) {
        try {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
            DecoratorMapper decoratorMapper = (DecoratorMapper)clazz.newInstance();
            decoratorMapper.init(this.config, properties, this.decoratorMapper);
            this.decoratorMapper = decoratorMapper;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Factory.report("Could not load DecoratorMapper class : " + string, classNotFoundException);
        }
        catch (Exception exception) {
            Factory.report("Could not initialize DecoratorMapper : " + string, exception);
        }
    }

    protected void clearParserMappings() {
        this.defaultPageParser = null;
        this.pageParsers = new HashMap();
    }

    protected void mapParser(String string, String string2) {
        try {
            PageParser pageParser = (PageParser)Class.forName(string2).newInstance();
            if (string == null) {
                this.defaultPageParser = pageParser;
            } else {
                this.pageParsers.put(string, pageParser);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Factory.report("Could not load PageParser class : " + string2, classNotFoundException);
        }
        catch (Exception exception) {
            Factory.report("Could not instantiate PageParser : " + string2, exception);
        }
    }
}

