/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class TypeCastPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new TypeCastPrinter();

    protected TypeCastPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        AST type = node.getFirstChild();
        if (settings.getBoolean(ConventionKeys.PADDING_CAST, false)) {
            out.print("( ", 84);
            PrinterFactory.create(type).print(type, out);
            out.print(" )", 85);
        } else {
            out.print("(", 84);
            PrinterFactory.create(type).print(type, out);
            out.print(")", 85);
        }
        if (settings.getBoolean(ConventionKeys.SPACE_AFTER_CAST, true)) {
            out.print(" ", out.last);
        }
        AST child = type.getNextSibling();
        while (child != null) {
            PrinterFactory.create(child).print(child, out);
            child = child.getNextSibling();
        }
    }
}

