/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.sublang.xpath;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.NamespaceContext;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;
import org.jbpm.bpel.sublang.xpath.TokenVariableContext;
import org.jbpm.bpel.variable.def.VariableDefinition;

public class GetVariablePropertyFunction
implements Function {
    private static final Log log = LogFactory.getLog((Class)GetVariablePropertyFunction.class);

    public Object call(Context context, List args) throws FunctionCallException {
        if (args.size() != 2) {
            throw new FunctionCallException("getVariableProperty() requires two arguments");
        }
        return GetVariablePropertyFunction.evaluate(args.get(0), args.get(1), context);
    }

    public static Object evaluate(Object variableArg, Object propertyArg, Context context) throws FunctionCallException {
        log.debug((Object)("evaluate(" + variableArg + ", " + propertyArg + ")"));
        Navigator nav = context.getNavigator();
        ContextSupport sup = context.getContextSupport();
        String variableName = StringFunction.evaluate((Object)variableArg, (Navigator)nav);
        TokenVariableContext variableContext = (TokenVariableContext)sup.getVariableContext();
        VariableDefinition variableDefinition = variableContext.findVariableDefinition(variableName);
        if (variableDefinition == null) {
            throw new FunctionCallException("variable not found: " + variableName);
        }
        String propertyName = StringFunction.evaluate((Object)propertyArg, (Navigator)nav);
        NamespaceContext nsContext = sup.getNamespaceContext();
        QName propertyQName = GetVariablePropertyFunction.toQName(propertyName, nsContext);
        Object propertyValue = variableDefinition.getPropertyValue(propertyQName, variableContext.getToken());
        log.debug((Object)("evaluate : " + propertyValue));
        return propertyValue;
    }

    private static QName toQName(String prefixedName, NamespaceContext namespaceContext) {
        int colonIndex = prefixedName.indexOf(58);
        if (colonIndex == -1) {
            return new QName(prefixedName);
        }
        String localName = prefixedName.substring(colonIndex + 1);
        String prefix = prefixedName.substring(0, colonIndex);
        String namespaceURI = namespaceContext.translateNamespacePrefixToUri(prefix);
        return new QName(namespaceURI, localName, prefix);
    }
}

