/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml;

import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.jpdl.xml.Problem;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

class ErrorHandlerAdapter
implements ErrorHandler {
    private final ProblemHandler handler;

    ErrorHandlerAdapter(ProblemHandler handler) {
        this.handler = handler;
    }

    public void error(SAXParseException pe) {
        Problem problem = new Problem(2, pe.getMessage(), (Throwable)pe.getException());
        this.fillLocationData(problem, pe);
        this.handler.add(problem);
    }

    public void fatalError(SAXParseException pe) {
        Problem problem = new Problem(1, pe.getMessage(), (Throwable)pe.getException());
        this.fillLocationData(problem, pe);
        this.handler.add(problem);
    }

    public void warning(SAXParseException pe) {
        Problem problem = new Problem(3, pe.getMessage(), (Throwable)pe.getException());
        this.fillLocationData(problem, pe);
        this.handler.add(problem);
    }

    private void fillLocationData(Problem problem, SAXParseException pe) {
        String resource = pe.getPublicId();
        if (resource == null) {
            resource = pe.getSystemId();
        }
        problem.setResource(resource);
        problem.setLine(new Integer(pe.getLineNumber()));
    }
}

