/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.query;

import cirrus.hibernate.QueryException;
import cirrus.hibernate.query.ClauseParser;
import cirrus.hibernate.query.Parser;
import cirrus.hibernate.query.ParserHelper;
import cirrus.hibernate.query.QueryTranslator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PreprocessingParser
implements Parser {
    private static final Set operators = new HashSet();
    private Map replacements;
    private boolean quoted;
    private StringBuffer quotedString;
    private ClauseParser parser = new ClauseParser();
    private String lastToken;

    public PreprocessingParser(Map replacements) {
        this.replacements = replacements;
    }

    public void token(String token, QueryTranslator q) throws QueryException {
        if (this.quoted) {
            this.quotedString.append(token);
        }
        if ("'".equals(token)) {
            if (this.quoted) {
                token = this.quotedString.toString();
            } else {
                this.quotedString = new StringBuffer(20).append(token);
            }
            boolean bl = this.quoted = !this.quoted;
        }
        if (this.quoted) {
            return;
        }
        if (ParserHelper.isWhitespace(token)) {
            return;
        }
        String substoken = (String)this.replacements.get(token);
        String string = token = substoken == null ? token : substoken;
        if (this.lastToken == null) {
            this.lastToken = token;
        } else {
            String doubleToken;
            String string2 = doubleToken = token.length() > 1 ? this.lastToken + ' ' + token : this.lastToken + token;
            if (operators.contains(doubleToken.toLowerCase())) {
                this.parser.token(doubleToken, q);
                this.lastToken = null;
            } else {
                this.parser.token(this.lastToken, q);
                this.lastToken = token;
            }
        }
    }

    public void start(QueryTranslator q) throws QueryException {
        this.quoted = false;
        this.parser.start(q);
    }

    public void end(QueryTranslator q) throws QueryException {
        if (this.lastToken != null) {
            this.parser.token(this.lastToken, q);
        }
        this.parser.end(q);
    }

    static {
        operators.add("<=");
        operators.add(">=");
        operators.add("=>");
        operators.add("=<");
        operators.add("!=");
        operators.add("<>");
        operators.add("!#");
        operators.add("!~");
        operators.add("!<");
        operators.add("!>");
        operators.add("is not");
        operators.add("not like");
        operators.add("not in");
        operators.add("not between");
        operators.add("not exists");
    }
}

