/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.coyote.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.net.ssl.SSLSocket;
import org.apache.tomcat.util.net.ServerSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.security.ServerSocketFactoryMBean;
import org.jboss.remoting.security.ServerSocketFactoryWrapper;

public class RemotingServerSocketFactory
extends ServerSocketFactory {
    private Map mbeanServerMap = null;
    private javax.net.ServerSocketFactory serverSocketFactory = null;
    private static Map serverSocketFactories = new HashMap();
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private boolean performHandshake = false;

    public RemotingServerSocketFactory() {
    }

    public RemotingServerSocketFactory(Map mbeanServerMap) {
        this.mbeanServerMap = mbeanServerMap;
    }

    private void init() throws InstantiationException {
        String locator = (String)this.attributes.get("locator");
        this.serverSocketFactory = (javax.net.ServerSocketFactory)serverSocketFactories.get(locator);
        if (this.serverSocketFactory == null) {
            MBeanServer mbeanserver = (MBeanServer)this.mbeanServerMap.get(locator);
            String serverSocketObjName = (String)this.attributes.get("serverSocketFactory");
            if (locator == null || mbeanserver == null || serverSocketObjName == null) {
                throw new InstantiationException("Can not create ServerSocketFactory with SSL support due to one of the following being null.\nlocator = " + locator + "\nmbeanserver = " + mbeanserver + "\nserverSocketObjName = " + serverSocketObjName);
            }
            try {
                ServerSocketFactoryMBean serverSocketFactoryMBean = (ServerSocketFactoryMBean)MBeanServerInvocationHandler.newProxyInstance(mbeanserver, new ObjectName(serverSocketObjName), ServerSocketFactoryMBean.class, false);
                this.serverSocketFactory = new ServerSocketFactoryWrapper(serverSocketFactoryMBean);
                this.performHandshake = true;
            }
            catch (Exception e) {
                InstantiationException iex = new InstantiationException("Error creating ServerSocketFactory proxy via MBeanServer");
                iex.setStackTrace(e.getStackTrace());
                throw iex;
            }
        }
    }

    public ServerSocket createSocket(int port) throws IOException, InstantiationException {
        if (this.serverSocketFactory == null) {
            this.init();
        }
        return this.serverSocketFactory.createServerSocket(port);
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException, InstantiationException {
        if (this.serverSocketFactory == null) {
            this.init();
        }
        return this.serverSocketFactory.createServerSocket(port, backlog);
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException, InstantiationException {
        if (this.serverSocketFactory == null) {
            this.init();
        }
        ServerSocket svrSocket = this.serverSocketFactory.createServerSocket(port, backlog, ifAddress);
        return svrSocket;
    }

    public Socket acceptSocket(ServerSocket socket) throws IOException {
        return socket.accept();
    }

    public void handshake(Socket sock) throws IOException {
        if (this.performHandshake) {
            ((SSLSocket)sock).startHandshake();
        }
    }

    public static void setServerSocketFactory(String locatorURI, javax.net.ServerSocketFactory svrSocketFactory) {
        serverSocketFactories.put(locatorURI, svrSocketFactory);
    }
}

