/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import javax.management.MBeanException;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.core.CommonBinding;
import org.jboss.ws.core.CommonBindingProvider;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.CommonSOAPBinding;
import org.jboss.ws.core.DirectionHolder;
import org.jboss.ws.core.EndpointInvocation;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.jaxrpc.handler.HandlerDelegateJAXRPC;
import org.jboss.ws.core.jaxrpc.handler.MessageContextJAXRPC;
import org.jboss.ws.core.jaxws.binding.BindingProviderImpl;
import org.jboss.ws.core.jaxws.handler.HandlerDelegateJAXWS;
import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
import org.jboss.ws.core.server.ServerHandlerDelegate;
import org.jboss.ws.core.server.ServiceEndpointInfo;
import org.jboss.ws.core.server.ServiceEndpointInvoker;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.utils.JavaUtils;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;

public abstract class AbstractServiceEndpointInvoker
implements ServiceEndpointInvoker {
    private static Logger log = Logger.getLogger(AbstractServiceEndpointInvoker.class);
    protected ServiceEndpointInfo seInfo;
    protected CommonBindingProvider bindingProvider;
    protected ServerHandlerDelegate delegate;

    public void init(ServiceEndpointInfo seInfo) {
        this.seInfo = seInfo;
        ServerEndpointMetaData sepMetaData = seInfo.getServerEndpointMetaData();
        if (sepMetaData.getType() == EndpointMetaData.Type.JAXRPC) {
            this.bindingProvider = new CommonBindingProvider(sepMetaData);
            this.delegate = new HandlerDelegateJAXRPC(sepMetaData);
        } else {
            this.bindingProvider = new BindingProviderImpl(sepMetaData);
            this.delegate = new HandlerDelegateJAXWS(sepMetaData);
        }
    }

    protected abstract Class loadServiceEndpoint() throws ClassNotFoundException;

    protected abstract Object createServiceEndpointInstance(Object var1, Class var2) throws Exception;

    protected abstract void invokeServiceEndpointInstance(Object var1, EndpointInvocation var2) throws Exception;

    protected abstract void destroyServiceEndpointInstance(Object var1);

    public boolean callRequestHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type) {
        return this.delegate.callRequestHandlerChain(sepMetaData, type);
    }

    public boolean callResponseHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type) {
        return this.delegate.callResponseHandlerChain(sepMetaData, type);
    }

    public void closeHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type) {
        this.delegate.closeHandlerChain(sepMetaData, type);
    }

    public boolean callFaultHandlerChain(ServerEndpointMetaData sepMetaData, HandlerMetaData.HandlerType type, Exception ex) {
        return this.delegate.callFaultHandlerChain(sepMetaData, type, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageAbstraction invoke(Object context) throws Exception {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)msgContext.getEndpointMetaData();
        MessageAbstraction reqMessage = msgContext.getMessageAbstraction();
        Class seImpl = this.loadServiceEndpoint();
        Object seInstance = this.createServiceEndpointInstance(context, seImpl);
        DirectionHolder direction = new DirectionHolder(DirectionHolder.Direction.InBound);
        HandlerMetaData.HandlerType[] handlerType = this.delegate.getHandlerTypeOrder();
        HandlerMetaData.HandlerType[] faultType = this.delegate.getHandlerTypeOrder();
        this.setInboundContextProperties();
        try {
            MessageAbstraction resMessage;
            boolean oneway = false;
            EndpointInvocation epInv = null;
            OperationMetaData opMetaData = null;
            CommonBinding binding = this.bindingProvider.getCommonBinding();
            binding.setHeaderSource(this.delegate);
            boolean handlersPass = this.callRequestHandlerChain(sepMetaData, handlerType[0]);
            if (handlersPass) {
                opMetaData = this.getDispatchDestination(sepMetaData, reqMessage);
                msgContext.setOperationMetaData(opMetaData);
                oneway = opMetaData.isOneWay();
                if (binding instanceof CommonSOAPBinding) {
                    ((CommonSOAPBinding)binding).checkMustUnderstand(opMetaData);
                }
                epInv = binding.unbindRequestMessage(opMetaData, reqMessage);
            }
            handlersPass = handlersPass && this.callRequestHandlerChain(sepMetaData, handlerType[1]);
            boolean bl = handlersPass = handlersPass && this.callRequestHandlerChain(sepMetaData, handlerType[2]);
            if (handlersPass) {
                msgContext.put(CommonMessageContext.ALLOW_EXPAND_TO_DOM, (Object)Boolean.TRUE);
                try {
                    if (msgContext.isModified()) {
                        log.debug((Object)"Handler modified payload, unbind message again");
                        reqMessage = msgContext.getMessageAbstraction();
                        epInv = binding.unbindRequestMessage(opMetaData, reqMessage);
                    }
                    this.invokeServiceEndpointInstance(seInstance, epInv);
                }
                finally {
                    msgContext.remove(CommonMessageContext.ALLOW_EXPAND_TO_DOM);
                }
                msgContext = this.processPivotInternal(msgContext, direction);
                this.setOutboundContextProperties();
                if (binding instanceof CommonSOAPBinding) {
                    XOPContext.setMTOMEnabled(((CommonSOAPBinding)binding).isMTOMEnabled());
                }
                resMessage = binding.bindResponseMessage(opMetaData, epInv);
                msgContext.setMessageAbstraction(resMessage);
            } else {
                resMessage = msgContext.getMessageAbstraction();
                msgContext = this.processPivotInternal(msgContext, direction);
                msgContext.setMessageAbstraction(resMessage);
            }
            if (!oneway) {
                handlersPass = this.callResponseHandlerChain(sepMetaData, handlerType[2]);
                faultType[2] = null;
                handlersPass = handlersPass && this.callResponseHandlerChain(sepMetaData, handlerType[1]);
                faultType[1] = null;
                handlersPass = handlersPass && this.callResponseHandlerChain(sepMetaData, handlerType[0]);
                faultType[0] = null;
            }
            MessageAbstraction messageAbstraction = resMessage = msgContext.getMessageAbstraction();
            return messageAbstraction;
        }
        catch (RuntimeException ex) {
            this.processPivotInternal(msgContext, direction);
            try {
                CommonBinding binding = this.bindingProvider.getCommonBinding();
                binding.bindFaultMessage(ex);
                boolean handlersPass = true;
                if (faultType[2] != null) {
                    boolean bl = handlersPass = handlersPass && this.callFaultHandlerChain(sepMetaData, faultType[2], ex);
                }
                if (faultType[1] != null) {
                    boolean bl = handlersPass = handlersPass && this.callFaultHandlerChain(sepMetaData, faultType[1], ex);
                }
                if (faultType[0] != null) {
                    handlersPass = handlersPass && this.callFaultHandlerChain(sepMetaData, faultType[0], ex);
                }
            }
            catch (RuntimeException subEx) {
                log.warn((Object)"Exception while processing handleFault: ", (Throwable)ex);
                ex = subEx;
            }
            throw ex;
        }
        finally {
            this.closeHandlerChain(sepMetaData, handlerType[2]);
            this.closeHandlerChain(sepMetaData, handlerType[1]);
            this.closeHandlerChain(sepMetaData, handlerType[0]);
            this.destroyServiceEndpointInstance(seInstance);
        }
    }

    protected void setInboundContextProperties() {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext instanceof MessageContextJAXWS) {
            msgContext.put("javax.xml.ws.binding.attachments.inbound", (Object)new HashMap());
        }
    }

    protected void setOutboundContextProperties() {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        if (msgContext instanceof MessageContextJAXWS) {
            msgContext.put("javax.xml.ws.binding.attachments.outbound", (Object)new HashMap());
        }
    }

    private CommonMessageContext processPivotInternal(CommonMessageContext msgContext, DirectionHolder direction) {
        if (direction.getDirection() == DirectionHolder.Direction.InBound) {
            EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
            msgContext = epMetaData.getType() == EndpointMetaData.Type.JAXRPC ? MessageContextJAXRPC.processPivot(msgContext) : MessageContextJAXWS.processPivot(msgContext);
            direction.setDirection(DirectionHolder.Direction.OutBound);
        }
        return msgContext;
    }

    private OperationMetaData getDispatchDestination(EndpointMetaData epMetaData, MessageAbstraction reqMessage) throws SOAPException {
        OperationMetaData opMetaData;
        String bindingID = epMetaData.getBindingId();
        if ("http://www.w3.org/2004/08/wsdl/http".equals(bindingID)) {
            if (epMetaData.getOperations().size() != 1) {
                throw new IllegalStateException("Multiple operations not supported for HTTP binding");
            }
            opMetaData = epMetaData.getOperations().get(0);
        } else {
            SOAPMessageImpl soapMessage = (SOAPMessageImpl)reqMessage;
            opMetaData = soapMessage.getOperationMetaData(epMetaData);
            SOAPHeader soapHeader = soapMessage.getSOAPHeader();
            if (opMetaData == null) {
                QName faultCode;
                String faultString;
                SOAPBodyImpl soapBody = (SOAPBodyImpl)soapMessage.getSOAPBody();
                SOAPBodyElement soapBodyElement = soapBody.getBodyElement();
                if (soapBodyElement != null) {
                    Name soapName = soapBodyElement.getElementName();
                    faultString = "Endpoint " + epMetaData.getPortName() + " does not contain operation meta data for: " + soapName;
                } else {
                    faultString = "Endpoint " + epMetaData.getPortName() + " does not contain operation meta data for empty soap body";
                }
                if (soapHeader != null && soapHeader.examineMustUnderstandHeaderElements("http://schemas.xmlsoap.org/soap/actor/next").hasNext()) {
                    faultCode = Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND;
                    throw new SOAPFaultException(faultCode, faultString, null, null);
                }
                faultCode = Constants.SOAP11_FAULT_CODE_CLIENT;
                throw new SOAPFaultException(faultCode, faultString, null, null);
            }
        }
        return opMetaData;
    }

    protected Method getImplMethod(Class implClass, Method seiMethod) throws ClassNotFoundException, NoSuchMethodException {
        String methodName = seiMethod.getName();
        Class<?>[] paramTypes = seiMethod.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class paramType = paramTypes[i];
            if (JavaUtils.isPrimitive(paramType)) continue;
            String paramTypeName = paramType.getName();
            paramTypes[i] = paramType = JavaUtils.loadJavaType(paramTypeName);
        }
        Method implMethod = implClass.getMethod(methodName, paramTypes);
        return implMethod;
    }

    public void handleInvocationException(Throwable th) throws Exception {
        if (th instanceof InvocationTargetException) {
            Throwable targetEx = ((InvocationTargetException)th).getTargetException();
            this.handleInvocationThrowable(targetEx);
        }
        if (th instanceof MBeanException) {
            throw ((MBeanException)th).getTargetException();
        }
        this.handleInvocationThrowable(th);
    }

    private void handleInvocationThrowable(Throwable th) throws Exception {
        if (th instanceof Exception) {
            throw (Exception)th;
        }
        if (th instanceof Error) {
            throw (Error)th;
        }
        throw new UndeclaredThrowableException(th);
    }
}

