/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.protocols.BSH;
import org.jgroups.stack.IpAddress;

public class Bsh {
    String host = "localhost";
    int port = 0;
    long timeout = 0L;
    String props = null;
    JChannel ch;

    public void start(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String tmp = args[i];
            if ("-props".equals(tmp)) {
                this.props = args[++i];
                continue;
            }
            if ("-host".equals(tmp)) {
                this.host = args[++i];
                continue;
            }
            if ("-port".equals(tmp)) {
                this.port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-timeout".equals(tmp)) {
                this.timeout = Long.parseLong(args[++i]);
                continue;
            }
            this.help();
            return;
        }
        this.runClient();
    }

    void runClient() throws Exception {
        this.ch = new JChannel(this.props);
        this.ch.connect(null);
        IpAddress addr = new IpAddress(this.host, this.port);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        block0: while (true) {
            BSH.BshHeader hdr;
            Message msg;
            System.out.print("> ");
            String line = reader.readLine();
            if (line.startsWith("quit") || line.startsWith("exit")) {
                this.ch.close();
                return;
            }
            if (line.startsWith("get")) {
                int i = 1;
                while (true) {
                    if (this.ch.getNumMessages() <= 0) continue block0;
                    Object obj = this.ch.receive(1000L);
                    System.out.println("#" + i++ + ": " + this.print(obj) + ", obj=" + obj);
                }
            }
            if (line.startsWith("destroyInterpreter")) {
                msg = new Message((Address)addr, null, line.getBytes());
                hdr = new BSH.BshHeader(1);
                msg.putHeader("BSH", hdr);
                this.sendAndReceive(msg, 1000L);
                continue;
            }
            msg = new Message((Address)addr, null, line.getBytes());
            hdr = new BSH.BshHeader(1);
            msg.putHeader("BSH", hdr);
            this.sendAndReceive(msg, this.timeout);
        }
    }

    Object print(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Message) {
            return ((Message)obj).getObject();
        }
        return obj;
    }

    void sendAndReceive(Message msg, long timeout) {
        try {
            this.ch.send(msg);
            Object obj = this.ch.receive(timeout);
            if (obj == null || !(obj instanceof Message)) {
                System.err.println("<-- " + obj);
            } else {
                Object result = ((Message)obj).getObject();
                System.out.println("<-- " + result);
            }
        }
        catch (Throwable t) {
            System.err.println("Bsh.sendAndReceive(): " + t);
        }
    }

    void help() {
        System.out.println("Bsh [-help] [-props <props>][-host <host>] [-port <port>] [-timeout <timeout>]");
    }

    public static void main(String[] args) {
        try {
            new Bsh().start(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

