/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.util;

import java.io.OutputStream;
import java.io.StringReader;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.stream.StreamSource;
import org.jboss.com.sun.xml.messaging.saaj.soap.MessageImpl;
import org.jboss.com.sun.xml.ws.pept.ept.MessageInfo;
import org.jboss.com.sun.xml.ws.util.FastInfosetReflection;
import org.jboss.com.sun.xml.ws.util.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastInfosetUtil {
    public static boolean isFastInfosetAccepted(String[] accepts) {
        if (accepts != null) {
            for (String accept : accepts) {
                if (!FastInfosetUtil.isFastInfosetAccepted(accept)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFastInfosetAccepted(String accept) {
        StringTokenizer st = new StringTokenizer(accept, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!token.equalsIgnoreCase("application/fastinfoset")) continue;
            return true;
        }
        return false;
    }

    public static String getFastInfosetFromAccept(List<String> accepts) {
        for (String accept : accepts) {
            StringTokenizer st = new StringTokenizer(accept, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.equalsIgnoreCase("application/fastinfoset")) {
                    return "application/fastinfoset";
                }
                if (!token.equalsIgnoreCase("application/soap+fastinfoset")) continue;
                return "application/soap+fastinfoset";
            }
        }
        return null;
    }

    public static void transcodeXMLStringToFI(String xml, OutputStream out) {
        try {
            XmlUtil.newTransformer().transform(new StreamSource(new StringReader(xml)), FastInfosetReflection.FastInfosetResult_new(out));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void ensureCorrectEncoding(MessageInfo messageInfo, SOAPMessage message) {
        String conneg = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        if (conneg == "optimistic") {
            ((MessageImpl)message).setIsFastInfoset(true);
        }
    }
}

