/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.reference.MethodPersistentReference;
import org.jboss.aspects.versioned.CollectionStateManager;

public class CollectionStateChangeInterceptor
implements Interceptor {
    protected CollectionStateManager manager;

    public CollectionStateChangeInterceptor(CollectionStateManager manager) {
        this.manager = manager;
    }

    public String getName() {
        return "CollectionChangeInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (invocation instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)invocation;
            long methodHash = methodInvocation.getMethodHash();
            Method managerMethod = this.manager.isManagerMethod(methodHash);
            if (managerMethod != null) {
                Object[] args = methodInvocation.getArguments();
                return managerMethod.invoke((Object)this.manager, args);
            }
            Object target = methodInvocation.getTargetObject();
            Method method = methodInvocation.getMethod();
            if (method == null) {
                HashMap methodMap = this.manager.getMethodMap();
                MethodPersistentReference ref = (MethodPersistentReference)methodMap.get(new Long(methodHash));
                method = (Method)ref.get();
            }
            return method.invoke(target, methodInvocation.getArguments());
        }
        return invocation.invokeNext();
    }
}

