/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Vector;
import junit.framework.TestCase;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.util.Util;

public class CloseTest
extends TestCase {
    JChannel channel;
    JChannel channel1;
    JChannel channel2;
    JChannel c1;
    JChannel c2;
    JChannel c3;
    int active_threads = 0;
    String props = "UDP(mcast_addr=228.8.8.3;mcast_port=45577;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000;enable_bundling=true;max_bundle_timeout=30;use_incoming_packet_handler=true;loopback=true):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true)";

    public CloseTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        String cfg = System.getProperty("config");
        if (cfg != null) {
            this.props = cfg;
        }
        this.active_threads = Thread.activeCount();
        System.out.println("active threads before (" + this.active_threads + "):\n" + Util.activeThreads());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        CloseTest.closeChannel(this.channel);
        CloseTest.closeChannel(this.channel1);
        CloseTest.closeChannel(this.channel2);
        CloseTest.closeChannel(this.c1);
        CloseTest.closeChannel(this.c2);
        CloseTest.closeChannel(this.c3);
        int current_active_threads = Thread.activeCount();
        System.out.println("active threads after (" + current_active_threads + "):\n" + Util.activeThreads());
        String msg = "";
        if (this.active_threads != current_active_threads) {
            msg = "active threads:\n" + Util.activeThreads();
        }
        CloseTest.assertEquals((String)msg, (int)this.active_threads, (int)current_active_threads);
    }

    private static void closeChannel(JChannel c) {
        if (c != null && (c.isOpen() || c.isConnected())) {
            c.close();
        }
    }

    public void testDoubleClose() throws ChannelException {
        System.out.println("-- creating channel1 --");
        this.channel1 = new JChannel(this.props);
        System.out.println("-- connecting channel1 --");
        this.channel1.connect("bla");
        System.out.println("-- closing channel1 --");
        this.channel1.close();
        System.out.println("-- closing channel1 (again) --");
        this.channel1.close();
        System.out.println("-- done, threads are ");
        Util.printThreads();
    }

    public void testCreationAndClose() throws Exception {
        System.out.println("-- creating channel1 --");
        this.channel1 = new JChannel(this.props);
        System.out.println("-- connecting channel1 --");
        this.channel1.connect("CloseTest1");
        System.out.println("-- closing channel1 --");
        this.channel1.close();
        System.out.println("-- done, threads are ");
        Util.printThreads();
    }

    public void testViewChangeReceptionOnChannelCloseByParticipant() throws Exception {
        this.c1 = new JChannel(this.props);
        System.out.println("-- connecting c1");
        this.c1.connect("X");
        Util.sleep(500L);
        CloseTest.dumpMessages("c1", this.c1);
        Address a1 = this.c1.getLocalAddress();
        this.c2 = new JChannel(this.props);
        System.out.println("-- connecting c2");
        this.c2.connect("X");
        Util.sleep(500L);
        Address a2 = this.c2.getLocalAddress();
        CloseTest.dumpMessages("c2", this.c2);
        System.out.println("-- closing c2");
        this.c2.close();
        Object obj = this.c1.receive(100L);
        CloseTest.assertTrue((boolean)(obj instanceof View));
        View v = (View)obj;
        Vector members = v.getMembers();
        System.out.println("-- first view of c1: " + v);
        CloseTest.assertEquals((int)2, (int)members.size());
        CloseTest.assertTrue((boolean)members.contains(a1));
        CloseTest.assertTrue((boolean)members.contains(a2));
        obj = this.c1.receive(100L);
        CloseTest.assertTrue((boolean)(obj instanceof View));
        v = (View)obj;
        members = v.getMembers();
        System.out.println("-- second view of c1: " + v);
        CloseTest.assertEquals((int)1, (int)members.size());
        CloseTest.assertTrue((boolean)members.contains(a1));
        CloseTest.assertFalse((boolean)members.contains(a2));
    }

    public void testViewChangeReceptionOnChannelCloseByCoordinator() throws Exception {
        this.c1 = new JChannel(this.props);
        this.c1.connect("X");
        Util.sleep(500L);
        CloseTest.dumpMessages("c1", this.c1);
        Address a1 = this.c1.getLocalAddress();
        this.c2 = new JChannel(this.props);
        this.c2.connect("X");
        Util.sleep(500L);
        Address a2 = this.c2.getLocalAddress();
        View v = (View)this.c2.receive(1L);
        Vector members = v.getMembers();
        CloseTest.assertEquals((int)2, (int)members.size());
        CloseTest.assertTrue((boolean)members.contains(a2));
        this.c1.close();
        Util.sleep(500L);
        System.out.println("queue of c2 is " + this.c2.dumpQueue());
        CloseTest.assertTrue((String)"found 0 messages in channel", (this.c2.getNumMessages() > 0 ? 1 : 0) != 0);
        Object obj = this.c2.receive(0L);
        CloseTest.assertTrue((boolean)(obj instanceof View));
        v = (View)obj;
        members = v.getMembers();
        CloseTest.assertEquals((int)1, (int)members.size());
        CloseTest.assertFalse((boolean)members.contains(a1));
        CloseTest.assertTrue((boolean)members.contains(a2));
        CloseTest.assertEquals((int)0, (int)this.c2.getNumMessages());
    }

    private static void dumpMessages(String msg, JChannel ch) throws Exception {
        while (ch.getNumMessages() > 0) {
            Object obj = ch.receive(0L);
            if (!(obj instanceof View)) continue;
            System.out.println(msg + ": " + obj);
        }
    }

    public void testConnectDisconnectConnectCloseSequence() throws ChannelException {
        System.out.println("-- creating channel --");
        this.channel = new JChannel(this.props);
        System.out.println("-- connecting channel to CloseTest1--");
        this.channel.connect("CloseTest1");
        System.out.println("view is " + this.channel.getView());
        System.out.println("-- disconnecting channel --");
        this.channel.disconnect();
        System.out.println("-- connecting channel to OtherGroup --");
        this.channel.connect("OtherGroup");
        System.out.println("view is " + this.channel.getView());
        System.out.println("-- closing channel --");
        this.channel.close();
        System.out.println("-- done, threads are ");
        Util.printThreads();
    }

    public void testConnectCloseSequenceWith2Members() throws ChannelException {
        System.out.println("-- creating channel --");
        this.channel = new JChannel(this.props);
        System.out.println("-- connecting channel --");
        this.channel.connect("X");
        System.out.println("view is " + this.channel.getView());
        System.out.println("-- creating channel1 --");
        this.channel1 = new JChannel(this.props);
        System.out.println("-- connecting channel1 --");
        this.channel1.connect("X");
        System.out.println("view is " + this.channel1.getView());
        System.out.println("-- closing channel1 --");
        this.channel1.close();
        Util.sleep(2000L);
        System.out.println("-- closing channel --");
        this.channel.close();
    }

    public void testCreationAndClose2() throws Exception {
        System.out.println("-- creating channel2 --");
        this.channel2 = new JChannel(this.props);
        System.out.println("-- connecting channel2 --");
        this.channel2.connect("CloseTest2");
        System.out.println("-- closing channel --");
        this.channel2.close();
        Util.sleep(2000L);
        Util.printThreads();
    }

    public void testChannelClosedException() throws Exception {
        System.out.println("-- creating channel --");
        this.channel = new JChannel(this.props);
        System.out.println("-- connecting channel --");
        this.channel.connect("CloseTestLoop");
        System.out.println("-- closing channel --");
        this.channel.close();
        Util.sleep(2000L);
        try {
            this.channel.connect("newGroup");
            CloseTest.fail();
        }
        catch (ChannelClosedException ex) {
            CloseTest.assertTrue((boolean)true);
        }
    }

    public void testCreationAndCloseLoop() throws Exception {
        System.out.println("-- creating channel --");
        this.channel = new JChannel(this.props);
        for (int i = 1; i <= 10; ++i) {
            System.out.println("-- connecting channel (attempt #" + i + " ) --");
            this.channel.connect("CloseTestLoop2");
            System.out.println("-- closing channel --");
            this.channel.close();
            System.out.println("-- reopening channel --");
            this.channel.open();
        }
        this.channel.close();
    }

    public void testShutdown() throws Exception {
        System.out.println("-- creating channel --");
        this.channel = new JChannel(this.props);
        System.out.println("-- connecting channel --");
        this.channel.connect("bla");
        System.out.println("-- shutting down channel --");
        this.channel.shutdown();
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        System.out.println("-- active threads:");
        for (int i = 0; i < threads.length; ++i) {
            System.out.println(threads[i]);
        }
        CloseTest.assertTrue((threads.length < 5 ? 1 : 0) != 0);
    }

    public void testMultipleConnectsAndDisconnects() throws Exception {
        this.c1 = new JChannel(this.props);
        CloseTest.assertTrue((boolean)this.c1.isOpen());
        CloseTest.assertFalse((boolean)this.c1.isConnected());
        this.c1.connect("bla");
        CloseTest.assertTrue((boolean)this.c1.isOpen());
        CloseTest.assertTrue((boolean)this.c1.isConnected());
        CloseTest.assertServiceAndClusterView(this.c1, 1);
        this.c2 = new JChannel(this.props);
        CloseTest.assertTrue((boolean)this.c2.isOpen());
        CloseTest.assertFalse((boolean)this.c2.isConnected());
        this.c2.connect("bla");
        CloseTest.assertTrue((boolean)this.c2.isOpen());
        CloseTest.assertTrue((boolean)this.c2.isConnected());
        CloseTest.assertServiceAndClusterView(this.c2, 2);
        Util.sleep(500L);
        CloseTest.assertServiceAndClusterView(this.c1, 2);
        this.c2.disconnect();
        CloseTest.assertTrue((boolean)this.c2.isOpen());
        CloseTest.assertFalse((boolean)this.c2.isConnected());
        Util.sleep(500L);
        CloseTest.assertServiceAndClusterView(this.c1, 1);
        this.c2.connect("bla");
        CloseTest.assertTrue((boolean)this.c2.isOpen());
        CloseTest.assertTrue((boolean)this.c2.isConnected());
        CloseTest.assertServiceAndClusterView(this.c2, 2);
        Util.sleep(300L);
        CloseTest.assertServiceAndClusterView(this.c1, 2);
        this.c3 = new JChannel(this.props);
        CloseTest.assertTrue((boolean)this.c3.isOpen());
        CloseTest.assertFalse((boolean)this.c3.isConnected());
        CloseTest.assertServiceAndClusterView(this.c1, 2);
        CloseTest.assertServiceAndClusterView(this.c2, 2);
        this.c1.disconnect();
        CloseTest.assertTrue((boolean)this.c1.isOpen());
        CloseTest.assertFalse((boolean)this.c1.isConnected());
        CloseTest.assertServiceAndClusterView(this.c2, 1);
        CloseTest.assertTrue((boolean)this.c3.isOpen());
        CloseTest.assertFalse((boolean)this.c3.isConnected());
        this.c1.connect("bla");
        CloseTest.assertTrue((boolean)this.c1.isOpen());
        CloseTest.assertTrue((boolean)this.c1.isConnected());
        CloseTest.assertServiceAndClusterView(this.c1, 2);
        Util.sleep(500L);
        CloseTest.assertServiceAndClusterView(this.c2, 2);
        CloseTest.assertTrue((boolean)this.c3.isOpen());
        CloseTest.assertFalse((boolean)this.c3.isConnected());
    }

    private static void assertServiceAndClusterView(Channel ch, int num) {
        View view = ch.getView();
        String msg = "view=" + view;
        CloseTest.assertNotNull((Object)view);
        CloseTest.assertEquals((String)msg, (int)num, (int)view.size());
    }
}

