/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.ExtendedMessageListener;
import org.jgroups.JChannelFactory;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.stack.GossipRouter;
import org.jgroups.util.Util;

public class MultiplexerMergeTest
extends TestCase {
    private static final String STACK_FILE = "stacks.xml";
    private static final String STACK_NAME = "tunnel";
    private static final int ROUTER_PORT = 12001;
    private static final String BIND_ADDR = "127.0.0.1";
    private JChannelFactory factory;
    private JChannelFactory factory2;
    private Channel ch1;
    private Channel ch2;
    private GossipRouter router;
    private RpcDispatcher dispatcher1;
    private RpcDispatcher dispatcher2;

    public MultiplexerMergeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new JChannelFactory();
        this.factory.setMultiplexerConfig(STACK_FILE);
        this.factory2 = new JChannelFactory();
        this.factory2.setMultiplexerConfig(STACK_FILE);
        this.startRouter();
        this.ch1 = this.factory.createMultiplexerChannel(STACK_NAME, "foo");
        this.dispatcher1 = new RpcDispatcher(this.ch1, null, null, new Object(), false);
        this.dispatcher1.setMessageListener(new MessageListenerAdaptor("listener1", "client1 initial state"));
        this.ch1.connect("bla");
        this.ch1.getState(null, 10000L);
        this.ch2 = this.factory2.createMultiplexerChannel(STACK_NAME, "foo");
        this.dispatcher2 = new RpcDispatcher(this.ch2, null, null, new Object(), false);
        this.dispatcher2.setMessageListener(new MessageListenerAdaptor("listener2", "client2 initial state"));
        this.ch2.connect("bla");
        boolean rc = this.ch2.getState(null, 10000L);
        System.out.println("sleeping for 5 seconds");
        Util.sleep(5000L);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.ch2.close();
        this.ch1.close();
        this.stopRouter();
    }

    public void testPartitionAndSubsequentMerge() throws Exception {
        this.partitionAndMerge();
    }

    private void partitionAndMerge() throws Exception {
        View v = this.ch2.getView();
        System.out.println("ch2 view is " + v);
        MultiplexerMergeTest.assertEquals((String)"channel2 should have 2 members", (int)2, (int)this.ch2.getView().size());
        System.out.println("++ simulating network partition by stopping the GossipRouter");
        this.stopRouter();
        System.out.println("sleeping for 20 seconds");
        Util.sleep(20000L);
        v = this.ch1.getView();
        System.out.println("-- ch1.view: " + v);
        v = this.ch2.getView();
        System.out.println("-- ch2.view: " + v);
        MultiplexerMergeTest.assertEquals((String)"channel2 should have 1 member (channels should have excluded each other)", (int)1, (int)v.size());
        System.out.println("++ simulating merge by starting the GossipRouter again");
        this.router.start();
        System.out.println("sleeping for 30 seconds");
        Util.sleep(30000L);
        v = this.ch1.getView();
        System.out.println("-- ch1.view: " + v);
        v = this.ch2.getView();
        System.out.println("-- ch2.view: " + v);
        MultiplexerMergeTest.assertEquals((String)"channel2 is supposed to have 2 members again after merge", (int)2, (int)this.ch2.getView().size());
    }

    private void startRouter() throws Exception {
        this.router = new GossipRouter(12001, BIND_ADDR);
        this.router.start();
    }

    private void stopRouter() {
        this.router.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static byte[] getInputStreamBytes(InputStream is) {
        byte[] b;
        block13: {
            b = null;
            if (is != null) {
                int bytes;
                b = new byte[1024];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((bytes = is.read(b)) != -1) {
                    baos.write(b, 0, bytes);
                }
                Object var5_5 = null;
                try {
                    if (baos != null) {
                        b = baos.toByteArray();
                        baos.close();
                    }
                    break block13;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                break block13;
                {
                    catch (Exception e) {
                        e.printStackTrace();
                        Object var5_6 = null;
                        try {
                            if (baos != null) {
                                b = baos.toByteArray();
                                baos.close();
                            }
                            break block13;
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        if (baos != null) {
                            b = baos.toByteArray();
                            baos.close();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
        return b;
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{MultiplexerMergeTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private final class MessageListenerAdaptor
    implements ExtendedMessageListener {
        private String m_name;
        private byte[] m_state = null;

        MessageListenerAdaptor(String name, String state) {
            this.m_name = name;
            if (state != null) {
                this.m_state = state.getBytes();
            }
        }

        public void receive(Message msg) {
            System.out.println(this.m_name + " MultiplexerMergeTest.receive() - not implemented");
        }

        public byte[] getState() {
            System.out.println(this.m_name + " MultiplexerMergeTest.getState() - returning byte[] state = " + new String(this.m_state));
            return this.m_state;
        }

        public void setState(byte[] state) {
            System.out.println(this.m_name + " MultiplexerMergeTest.setState(byte[]) - setting state = " + new String(state));
            this.m_state = state;
        }

        public void setState(InputStream is) {
            this.m_state = MultiplexerMergeTest.getInputStreamBytes(is);
            try {
                is.close();
            }
            catch (IOException e) {
                System.out.println(this.m_name + " MultiplexerMergeTest.setState(InputStream): " + e.toString());
            }
            System.out.println(this.m_name + " MultiplexerMergeTest.setState(InputStream) - setting stream state = " + new String(this.m_state));
        }

        public void getState(OutputStream os) {
            System.out.println(this.m_name + " MultiplexerMergeTest.getState(OutputStream) returning stream state = " + new String(this.m_state));
            try {
                os.write(this.m_state);
                os.flush();
                os.close();
            }
            catch (IOException e) {
                System.out.println(this.m_name + " MultiplexerMergeTest.getState(OutputStream) failed: " + e.toString());
            }
        }

        public byte[] getState(String state_id) {
            System.out.println(this.m_name + " MultiplexerMergeTest.getState(String) - not implemented");
            return null;
        }

        public void getState(String state_id, OutputStream os) {
            System.out.println(this.m_name + " MultiplexerMergeTest.getState(String, InputStream) - not implemented");
        }

        public void setState(String state_id, byte[] state) {
            System.out.println(this.m_name + " MultiplexerMergeTest.setState(String, byte[]) - not implemented");
        }

        public void setState(String state_id, InputStream is) {
            System.out.println(this.m_name + " MultiplexerMergeTest.setState(String, InputStream) - not implemented");
        }
    }
}

