/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.processor.model.java;

import com.sun.codemodel.JClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.com.sun.tools.ws.processor.model.ModelException;
import org.jboss.com.sun.tools.ws.processor.model.java.JavaParameter;
import org.jboss.com.sun.tools.ws.processor.model.java.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethod {
    private String name;
    private List<JavaParameter> parameters = new ArrayList<JavaParameter>();
    private List<String> exceptions = new ArrayList<String>();
    private List<JClass> exceptionClasses = new ArrayList<JClass>();
    private JavaType returnType;
    private String declaringClass;
    private boolean throwsRemoteException = true;

    public JavaMethod() {
    }

    public JavaMethod(String name) {
        this.name = name;
        this.returnType = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JavaType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(JavaType returnType) {
        this.returnType = returnType;
    }

    public boolean hasParameter(String paramName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!paramName.equals(this.parameters.get(i).getName())) continue;
            return true;
        }
        return false;
    }

    public void addParameter(JavaParameter param) {
        if (this.hasParameter(param.getName())) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this.parameters.add(param);
    }

    public JavaParameter getParameter(String paramName) {
        for (int i = 0; i < this.parameters.size(); ++i) {
            JavaParameter jParam = this.parameters.get(i);
            if (!paramName.equals(jParam.getParameter().getName())) continue;
            return jParam;
        }
        return null;
    }

    public Iterator<JavaParameter> getParameters() {
        return this.parameters.iterator();
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public List<JavaParameter> getParametersList() {
        return this.parameters;
    }

    public void setParametersList(List<JavaParameter> l) {
        this.parameters = l;
    }

    public boolean hasException(String exception) {
        return this.exceptions.contains(exception);
    }

    public void addException(String exception) {
        if (this.hasException(exception)) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this.exceptions.add(exception);
    }

    public Iterator getExceptions() {
        return this.exceptions.iterator();
    }

    public List getExceptionsList() {
        return this.exceptions;
    }

    public void setExceptionsList(List l) {
        this.exceptions = l;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public void setDeclaringClass(String declaringClass) {
        this.declaringClass = declaringClass;
    }

    public boolean getThrowsRemoteException() {
        return this.throwsRemoteException;
    }

    public void setThrowsRemoteException(boolean throwsRemoteException) {
        this.throwsRemoteException = throwsRemoteException;
    }

    public void addExceptionClass(JClass ex) {
        this.exceptionClasses.add(ex);
    }

    public List<JClass> getExceptionClasses() {
        return this.exceptionClasses;
    }
}

