/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.core;

import com.icesoft.faces.webapp.command.SessionExpired;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.common.standard.FixedXMLContentHandler;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestVerifier
implements Server {
    private static final Log log = LogFactory.getLog((Class)RequestVerifier.class);
    private static final SessionExpired SessionExpired = new SessionExpired();
    private static final ResponseHandler SessionExpiredResponse = new FixedXMLContentHandler(){

        public void writeTo(Writer writer) throws IOException {
            SessionExpired.serializeTo(writer);
        }
    };
    private static final ResponseHandler EmptyResponse = new ResponseHandler(){

        public void respond(Response response) throws Exception {
            response.setHeader("Content-Length", 0);
        }
    };
    private String sessionID;
    private Server server;

    public RequestVerifier(String sessionID, Server server) {
        this.sessionID = sessionID;
        this.server = server;
    }

    public void service(Request request) throws Exception {
        if ("GET".equalsIgnoreCase(request.getMethod())) {
            log.info((Object)"'POST' request expected. Dropping connection...");
            request.respondWith(EmptyResponse);
        } else if (request.containsParameter("ice.session")) {
            if (this.sessionID.equals(request.getParameter("ice.session"))) {
                this.server.service(request);
            } else {
                log.debug((Object)"Missmatched 'ice.session' value. Session has expired.");
                request.respondWith(SessionExpiredResponse);
            }
        } else {
            log.info((Object)"Request missing 'ice.session' required parameter. Dropping connection...");
            request.respondWith(EmptyResponse);
        }
    }

    public void shutdown() {
        this.server.shutdown();
    }
}

