/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class utilInputStreamFromReader
extends InputStream {
    private Reader m_Reader;
    private String m_Encoding;
    private byte[] m_ByteBuf;
    private int m_BytesConsumed;
    private Hashtable m_ValidEncodings;
    private int m_Length;

    public utilInputStreamFromReader(Reader reader) {
        this.m_Reader = reader;
        this.m_Encoding = null;
        this.m_ByteBuf = null;
        this.m_BytesConsumed = 0;
        this.m_ValidEncodings = new Hashtable();
    }

    public utilInputStreamFromReader(Reader reader, String string) throws UnsupportedEncodingException {
        this(reader);
        this.m_Encoding = string;
        this.checkEncoding(this.m_Encoding);
    }

    public void close() throws IOException {
        this.m_Reader.close();
    }

    public int read() throws IOException {
        if (this.m_Encoding == null) {
            if (!this.fillBuffer()) {
                return -1;
            }
            return this.m_ByteBuf[this.m_BytesConsumed++];
        }
        return this.m_Reader.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.fillBuffer()) {
            return -1;
        }
        int n3 = Math.min(n2, this.m_ByteBuf.length - this.m_BytesConsumed);
        System.arraycopy(this.m_ByteBuf, this.m_BytesConsumed, byArray, n, n3);
        this.m_BytesConsumed += n3;
        return n3;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.m_Encoding == null) {
            throw new IOException("This method is not suitable for data that is not encoded with a supported encoding scheme");
        }
        return this.m_Reader.read(cArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    private boolean fillBuffer() throws IOException {
        int n;
        if (this.m_ByteBuf != null && this.m_ByteBuf.length > this.m_BytesConsumed) {
            return true;
        }
        char[] cArray = new char[1024];
        int n2 = 0;
        while ((n = this.m_Reader.read(cArray, n2, cArray.length - n2)) != -1 && (n2 += n) != cArray.length) {
        }
        if (n2 == 0) {
            return false;
        }
        String string = new String(cArray, 0, n2);
        this.m_Length += n2;
        this.m_ByteBuf = this.m_Encoding == null ? string.getBytes() : string.getBytes(this.m_Encoding);
        this.m_BytesConsumed = 0;
        return true;
    }

    public int getLength() {
        return this.m_Length;
    }

    private void checkEncoding(String string) throws UnsupportedEncodingException {
        if (this.m_ValidEncodings.get(string) != null) {
            return;
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(), this.m_Encoding);
        try {
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_ValidEncodings.put(string, string);
    }
}

