/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.lang;

import com.mchange.v1.jvm.InternalNameUtils;
import com.mchange.v1.jvm.TypeFormatException;
import com.mchange.v1.lang.AmbiguousClassNameException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ClassUtils {
    static final String[] EMPTY_SA = new String[0];
    static Map primitivesToClasses;

    public static Set allAssignableFrom(Class clazz) {
        HashSet hashSet = new HashSet();
        Class clazz2 = clazz;
        while (clazz2 != null) {
            hashSet.add(clazz2);
            clazz2 = clazz2.getSuperclass();
        }
        ClassUtils.addSuperInterfacesToSet(clazz, hashSet);
        return hashSet;
    }

    public static String simpleClassName(Class clazz) {
        try {
            String string = ClassUtils.simpleClassName(clazz.getName());
            if (clazz.isArray()) {
                string = InternalNameUtils.decodeType(string);
            }
            return string;
        }
        catch (TypeFormatException typeFormatException) {
            typeFormatException.printStackTrace();
            throw new InternalError("Huh? the name of a genuine type failed to decode!");
        }
    }

    private static String simpleClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(n + 1);
        if (string2.indexOf(36) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            int n2 = 0;
            int n3 = stringBuffer.length();
            while (n2 < n3) {
                if (stringBuffer.charAt(n2) == '$') {
                    stringBuffer.setCharAt(n2, '.');
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
        return string2;
    }

    public static boolean isPrimitive(String string) {
        return primitivesToClasses.get(string) != null;
    }

    public static Class classForPrimitive(String string) {
        return (Class)primitivesToClasses.get(string);
    }

    public static Class classForSimpleName(String string, String[] stringArray, String[] stringArray2) throws AmbiguousClassNameException, ClassNotFoundException {
        HashSet<String> hashSet = new HashSet<String>();
        Class<?> clazz = ClassUtils.classForPrimitive(string);
        if (clazz == null) {
            if (stringArray == null) {
                stringArray = EMPTY_SA;
            }
            if (stringArray2 == null) {
                stringArray2 = EMPTY_SA;
            }
            int n = 0;
            int n2 = stringArray2.length;
            while (n < n2) {
                String string2 = ClassUtils.fqcnLastElement(stringArray2[n]);
                if (!hashSet.add(string2)) {
                    throw new IllegalArgumentException("Duplicate imported classes: " + string2);
                }
                if (string.equals(string2)) {
                    clazz = Class.forName(stringArray2[n]);
                }
                ++n;
            }
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.lang." + string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                int n3 = 0;
                int n4 = stringArray.length;
                while (n3 < n4) {
                    block14: {
                        try {
                            String string3 = stringArray[n3] + '.' + string;
                            Class<?> clazz2 = Class.forName(string3);
                            if (clazz == null) {
                                clazz = clazz2;
                                break block14;
                            }
                            throw new AmbiguousClassNameException(string, clazz, clazz2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    ++n3;
                }
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Could not find a class whose unqualified name is \"" + string + "\" with the imports supplied.");
        }
        return clazz;
    }

    public static String fqcnLastElement(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private static void addSuperInterfacesToSet(Class clazz, Set set) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            set.add(classArray[n]);
            ClassUtils.addSuperInterfacesToSet(classArray[n], set);
            ++n;
        }
    }

    private ClassUtils() {
    }

    static {
        HashMap<String, Class<Object>> hashMap = new HashMap<String, Class<Object>>();
        hashMap.put("boolean", Boolean.TYPE);
        hashMap.put("int", Integer.TYPE);
        hashMap.put("char", Character.TYPE);
        hashMap.put("short", Short.TYPE);
        hashMap.put("int", Integer.TYPE);
        hashMap.put("long", Long.TYPE);
        hashMap.put("float", Float.TYPE);
        hashMap.put("double", Double.TYPE);
        hashMap.put("void", Void.TYPE);
        primitivesToClasses = Collections.unmodifiableMap(hashMap);
    }
}

