/*
* JBoss, Home of Professional Open Source.
* Copyright 2008, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.security.ejb.jbas6006;

import java.util.Properties;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.login.LoginContext;

import junit.framework.Test;

import org.jboss.security.SecurityAssociation;
import org.jboss.test.JBossTestCase;
import org.jboss.test.util.AppCallbackHandler;

/**
 * [JBAS-6006] Wrong CallerPrincipal provided to ejbCreate method
 * in Stateful session bean.
 * 
 * @author darran.lofthouse@jboss.com
 * @since 30th September 2008
 */
public class JBAS6006TestCase extends JBossTestCase
{

   private LoginContext lc;

   public JBAS6006TestCase(String name)
   {
      super(name);
   }

   public void testSecuredCalls() throws Exception
   {      
      SecurityAssociation.clear();
      
      StatefulSessionHome home = getHome();
      StatefulSessionRemote remote = home.create("guest");
      remote.testCaller("guest");
      remote.remove();
      

      login("jduke", "theduke".toCharArray());
      home = getHome();
      remote = home.create("jduke");
      remote.testCaller("jduke");
      remote.remove();
      logout();
   }

   private void login(String username, char[] password) throws Exception
   {
      AppCallbackHandler handler = new AppCallbackHandler(username, password);
      lc = new LoginContext("other", handler);
      lc.login();
      log.debug("Created LoginContext, subject=" + lc.getSubject());
   }

   private void logout() throws Exception
   {
      if (lc != null)
      {
         lc.logout();
      }
   }

   private StatefulSessionHome getHome() throws Exception
   {
      Properties env = new Properties();
      env.setProperty(Context.INITIAL_CONTEXT_FACTORY, "org.jnp.interfaces.NamingContextFactory");

      InitialContext ctx = new InitialContext(env);

      Object homeObj = ctx.lookup("jbas6006.StatefulSessionBean");
      StatefulSessionHome home = (StatefulSessionHome) PortableRemoteObject.narrow(homeObj, StatefulSessionHome.class);

      return home;
   }

   public static Test suite() throws Exception
   {
      return JBossTestCase.getDeploySetup(JBAS6006TestCase.class, "security-jbas6006.jar");
   }
}
