/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.security.test;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

import javax.naming.InitialContext;
import javax.sql.DataSource;

import junit.framework.Test;

import org.jboss.test.JBossTestCase;

/**
 * 
 * Tests password encryption for datasource
 * 
 * @author <a href="mmoyses@redhat.com">Marcus Moyses</a>
 * @version $Revision: 1.1 $
 */
public class DatasourcePasswordEncryptionUnitTestCase extends JBossTestCase
{

   public DatasourcePasswordEncryptionUnitTestCase(String name)
   {
      super(name);
   }

   public static Test suite() throws Exception
   {
      // Clear any default login behavior
      System.setProperty("jbosstest.secure", "false");
      Test t1 = getDeploySetup(DatasourcePasswordEncryptionUnitTestCase.class, "encrypted-password.jar");
      return t1;
   }

   //   public void testPasswordEncryption() throws Throwable
   //   {
   //      log.info("+++ testPasswordEncryption");
   //      InitialContext ctx = super.getInitialContext();
   //      Connection conn = null;
   //      Statement stmt = null;
   //      try
   //      {
   //         log.info("Lookup EncryptedSecureIdentityDS");
   //         DataSource ds = (DataSource) ctx.lookup("EncryptedSecureIdentityDS");
   //         conn = ds.getConnection();
   //         log.info("Connected to EncryptedSecurityIdentityDS");
   //         stmt = conn.createStatement();
   //         log.info("Creating temp table TEST");
   //         stmt.execute("CREATE TEMP TABLE TEST (NUM INTEGER, PRIMARY KEY (NUM))");
   //         stmt.close();
   //         log.info("Temp table created");
   //         stmt = conn.createStatement();
   //         stmt.execute("SHUTDOWN");
   //         stmt.close();
   //      }
   //      catch (SQLException ignore)
   //      {
   //         log.debug("Failed to create table", ignore);
   //         fail("Failed to create table");
   //      }
   //      finally
   //      {
   //         if (stmt != null)
   //         {
   //            try
   //            {
   //               stmt.close();
   //            }
   //            catch (SQLException ignore)
   //            {
   //            }
   //         }
   //         if (conn != null)
   //            conn.close();
   //      }
   //   }

   public void testNonDefaultPasswordEncryption() throws Throwable
   {
      log.info("+++ testNonDefaultPasswordEncryption");
      InitialContext ctx = super.getInitialContext();
      DataSource ds = null;
      DataSource ds2 = null;
      Connection conn = null;
      Connection conn2 = null;
      Statement stmt = null;
      try
      {
         log.info("Lookup DefaultPasswordDS");
         ds = (DataSource) ctx.lookup("DefaultPasswordDS");
         conn = ds.getConnection();
         log.info("Connected to DefaultPasswordDS");
         stmt = conn.createStatement();
         log.info("Changing password");
         stmt.execute("SET PASSWORD dynamcusr");
         stmt.close();
         log.info("Password changed");
      }
      catch (SQLException ignore)
      {
         log.debug("Failed to update password", ignore);
         fail("Failed to update password");
      }
      finally
      {
         if (stmt != null)
         {
            try
            {
               stmt.close();
            }
            catch (SQLException ignore)
            {
            }
         }
      }
      try
      {
         log.info("Trying to connect again");
         conn2 = ds.getConnection();
         fail("Shouldn't be able to connected again");
      }
      catch (SQLException ignore)
      {
         log.info("Access was correctly denied");
      }
      finally
      {
         if (conn2 != null)
            conn2.close();
      }
      try
      {
         log.info("Lookup NonDefaultPasswordDS");
         ds2 = (DataSource) ctx.lookup("NonDefaultPasswordDS");
         conn2 = ds2.getConnection();
         log.info("Connected to NonDefaultPasswordDS");
         stmt = conn2.createStatement();
         stmt.execute("SHUTDOWN");
         stmt.close();
      }
      catch (SQLException ignore)
      {
         log.debug("Access was incorrectly denied", ignore);
         fail("Access was incorrectly denied");
      }
      finally
      {
         if (stmt != null)
         {
            try
            {
               stmt.close();
            }
            catch (SQLException ignore)
            {
            }
         }
         if (conn != null)
            conn.close();
         if (conn2 != null)
            conn2.close();
      }
   }
}
