/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import org.jboss.aop.Advised;
import org.jboss.aop.AspectManager;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.proxy.container.AOPProxyFactory;
import org.jboss.aop.proxy.container.AOPProxyFactoryMixin;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.AspectManaged;
import org.jboss.aop.proxy.container.ContainerCache;
import org.jboss.aop.proxy.container.ContainerProxyFactory;
import org.jboss.aop.proxy.container.Delegate;
import org.jboss.repository.spi.MetaDataContext;

public class GeneratedAOPProxyFactory
implements AOPProxyFactory {
    public Object createAdvisedProxy(AOPProxyFactoryParameters params) {
        return this.createAdvisedProxy(params.isObjectAsSuperClass(), params.getProxiedClass(), params.getInterfaces(), params.getMixins(), params.getSimpleMetaData(), params.getTarget(), params.getMetaDataContext(), params.getContainerCache());
    }

    private Object createAdvisedProxy(boolean objectAsSuper, Class proxiedClass, Class[] interfaces, AOPProxyFactoryMixin[] mixins, SimpleMetaData simpleMetaData, Object target, MetaDataContext metaDataContext, ContainerCache containerCache) {
        AspectManager manager = AspectManager.instance();
        if (target != null) {
            if (proxiedClass != null) {
                if (!proxiedClass.isAssignableFrom(target.getClass())) {
                    throw new RuntimeException("Specified class type " + proxiedClass.getName() + " and target " + target.getClass().getName() + " are not compatible");
                }
            } else {
                proxiedClass = target.getClass();
            }
        } else if (proxiedClass == null) {
            proxiedClass = Object.class;
        }
        return this.getProxy(objectAsSuper, manager, proxiedClass, interfaces, mixins, simpleMetaData, target, metaDataContext, containerCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getProxy(boolean objectAsSuper, AspectManager manager, Class proxiedClass, Class[] interfaces, AOPProxyFactoryMixin[] mixins, SimpleMetaData simpleMetaData, Object target, MetaDataContext metaDataContext, ContainerCache containerCache) {
        try {
            Class proxyClass = null;
            boolean isAdvised = Advised.class.isAssignableFrom(proxiedClass);
            if (target instanceof Untransformable || isAdvised && interfaces == null && mixins == null && metaDataContext == null && simpleMetaData == null) {
                return target;
            }
            Object object = ContainerCache.mapLock;
            synchronized (object) {
                if (containerCache == null) {
                    containerCache = ContainerCache.initialise(manager, proxiedClass, interfaces, mixins, metaDataContext, simpleMetaData);
                }
                if (!containerCache.hasAspects() && !containerCache.requiresInstanceAdvisor()) {
                    return target;
                }
                proxyClass = this.generateProxy(objectAsSuper, containerCache);
            }
            return this.instantiateAndConfigureProxy(proxyClass, containerCache, simpleMetaData, target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class generateProxy(boolean objectAsSuper, ContainerCache cache) throws Exception {
        Class proxyClass = ContainerProxyFactory.getProxyClass(objectAsSuper, cache.getKey(), cache.getAdvisor());
        return proxyClass;
    }

    private Object instantiateAndConfigureProxy(Class proxyClass, ContainerCache cache, SimpleMetaData metadata, Object target) throws Exception {
        AspectManaged proxy = (AspectManaged)proxyClass.newInstance();
        proxy.setAdvisor(cache.getClassAdvisor());
        if (cache.getInstanceContainer() != null) {
            proxy.setInstanceAdvisor(cache.getInstanceContainer());
        }
        if (metadata != null) {
            proxy.setMetadata(metadata);
        }
        if (target != null) {
            ((Delegate)((Object)proxy)).setDelegate(target);
        } else {
            ((Delegate)((Object)proxy)).setDelegate(new Object());
        }
        return proxy;
    }
}

