/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.logging.Logger;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AbstractDependencyItem
extends JBossObject
implements DependencyItem {
    private static final Logger log = Logger.getLogger(AbstractDependencyItem.class);
    private Object iDependOn;
    private Object name;
    private ControllerState whenRequired = ControllerState.DESCRIBED;
    private ControllerState dependentState;
    private boolean resolved = false;

    public AbstractDependencyItem() {
    }

    public AbstractDependencyItem(Object name, Object iDependOn, ControllerState whenRequired, ControllerState dependentState) {
        this.name = name;
        this.iDependOn = iDependOn;
        this.whenRequired = whenRequired;
        this.dependentState = dependentState;
    }

    public Object getName() {
        return this.name;
    }

    public Object getIDependOn() {
        return this.iDependOn;
    }

    public ControllerState getWhenRequired() {
        return this.whenRequired;
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean resolve(Controller controller) {
        boolean previous = this.resolved;
        ControllerContext context = null;
        if (this.dependentState == null) {
            context = controller.getInstalledContext(this.iDependOn);
        } else {
            context = controller.getContext(this.iDependOn, this.dependentState);
            if (context == null && this.dependentState == ControllerState.INSTALLED) {
                context = controller.getInstalledContext(this.iDependOn);
            }
        }
        if (context == null) {
            this.resolved = false;
            ControllerContext unresolvedContext = controller.getContext(this.iDependOn, null);
            if (unresolvedContext != null && ControllerMode.ON_DEMAND.equals(unresolvedContext.getMode())) {
                try {
                    controller.enableOnDemand(unresolvedContext);
                }
                catch (Throwable ignored) {
                    if (log.isTraceEnabled()) {
                        log.trace("Unexpected error", ignored);
                    }
                }
            }
        } else {
            this.addDependsOnMe(controller, context);
            this.resolved = true;
        }
        if (previous != this.resolved) {
            this.flushJBossObjectCache();
            if (log.isTraceEnabled()) {
                if (this.resolved) {
                    log.trace("Resolved " + this);
                } else {
                    log.trace("Unresolved " + this);
                }
            }
        }
        return this.resolved;
    }

    public void unresolved(Controller controller) {
        if (this.resolved) {
            this.resolved = false;
            this.flushJBossObjectCache();
            log.trace("Forced unresolved " + this);
        }
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        buffer.append(" dependsOn=").append(this.iDependOn);
        if (this.whenRequired != null) {
            buffer.append(" whenRequired=").append(this.whenRequired.getStateString());
        }
        if (this.dependentState != null) {
            buffer.append(" dependentState=").append(this.dependentState.getStateString());
        }
        buffer.append(" resolved=").append(this.resolved);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.name).append(" dependsOn ").append(this.iDependOn);
    }

    protected void addDependsOnMe(Controller controller, ControllerContext context) {
        DependencyInfo info = context.getDependencyInfo();
        if (info != null) {
            info.addDependsOnMe(this);
        }
    }

    protected void setIDependOn(Object iDependOn) {
        this.iDependOn = iDependOn;
        this.flushJBossObjectCache();
    }

    protected void setResolved(boolean resolved) {
        this.resolved = resolved;
        this.flushJBossObjectCache();
    }
}

