/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.bootstrap.standalone;

import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.util.CollectionsFactory;

public class StandaloneBootstrap
extends BasicBootstrap {
    protected BeanXMLDeployer deployer;
    protected List deployments = CollectionsFactory.createCopyOnWriteList();
    protected String[] args;

    public static void main(String[] stringArray) throws Exception {
        StandaloneBootstrap standaloneBootstrap = new StandaloneBootstrap(stringArray);
        standaloneBootstrap.run();
    }

    public StandaloneBootstrap(String[] stringArray) throws Exception {
        this.args = stringArray;
    }

    public void bootstrap() throws Throwable {
        URL uRL;
        super.bootstrap();
        this.deployer = new BeanXMLDeployer(this.getKernel());
        Runtime.getRuntime().addShutdownHook(new Shutdown());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> enumeration = classLoader.getResources("jboss-beans.xml");
        while (enumeration.hasMoreElements()) {
            uRL = enumeration.nextElement();
            this.deploy(uRL);
        }
        enumeration = classLoader.getResources("META-INF/jboss-beans.xml");
        while (enumeration.hasMoreElements()) {
            uRL = enumeration.nextElement();
            this.deploy(uRL);
        }
        this.deployer.validate();
    }

    protected void deploy(URL uRL) throws Throwable {
        this.log.debug((Object)("Deploying " + uRL));
        KernelDeployment kernelDeployment = this.deployer.deploy(uRL);
        this.deployments.add(kernelDeployment);
        this.log.debug((Object)("Deployed " + uRL));
    }

    protected void undeploy(KernelDeployment kernelDeployment) {
        this.log.debug((Object)("Undeploying " + kernelDeployment.getName()));
        this.deployments.remove(kernelDeployment);
        try {
            this.deployer.undeploy(kernelDeployment);
            this.log.debug((Object)("Undeployed " + kernelDeployment.getName()));
        }
        catch (Throwable throwable) {
            this.log.warn((Object)("Error during undeployment: " + kernelDeployment.getName()), throwable);
        }
    }

    protected class Shutdown
    extends Thread {
        protected Shutdown() {
        }

        public void run() {
            StandaloneBootstrap.this.log.info((Object)"Shutting down");
            ListIterator listIterator = StandaloneBootstrap.this.deployments.listIterator(StandaloneBootstrap.this.deployments.size());
            while (listIterator.hasPrevious()) {
                KernelDeployment kernelDeployment = (KernelDeployment)listIterator.previous();
                StandaloneBootstrap.this.undeploy(kernelDeployment);
            }
        }
    }
}

