/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection;

import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContextType;
import org.hibernate.Session;
import org.jboss.aop.util.PayloadKey;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.entity.ExtendedEntityManager;
import org.jboss.ejb3.entity.ExtendedHibernateSession;
import org.jboss.ejb3.entity.ExtendedPersistenceContext;
import org.jboss.ejb3.entity.InjectedEntityManager;
import org.jboss.ejb3.entity.InjectedHibernateSession;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.injection.EntityManagerFieldInjector;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.injection.PojoInjector;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.logging.Logger;

public abstract class EntityManagerInjector
implements Injector,
PojoInjector {
    protected static final Logger log = Logger.getLogger(EntityManagerFieldInjector.class);
    protected Container container;
    protected ManagedEntityManagerFactory factory;
    protected PersistenceContextType type;

    protected EntityManagerInjector(Container container, ManagedEntityManagerFactory factory, PersistenceContextType type) {
        this.container = container;
        this.factory = factory;
        this.type = type;
    }

    protected Object getEntityManager(BeanContext ctx, boolean isTransient, Class emType) {
        Serializable entityManager;
        if (this.type == PersistenceContextType.EXTENDED) {
            if (!(this.container instanceof StatefulContainer)) {
                throw new IllegalStateException("EXTENDED persistence contexts can only be used within a Stateful Session bean");
            }
            ExtendedPersistenceContext pc = (ExtendedPersistenceContext)ctx.getMetaData().getMetaData((Object)"LONG_LIVED_SESSION", (Object)this.factory.getJndiName());
            if (pc == null) {
                entityManager = emType.getName().equals(Session.class.getName()) ? new ExtendedHibernateSession(isTransient, this.factory, this.container.getInitialContextProperties()) : new ExtendedEntityManager(isTransient, this.factory, this.container.getInitialContextProperties());
                ctx.getMetaData().addMetaData((Object)"LONG_LIVED_SESSION", (Object)this.factory.getJndiName(), (Object)entityManager, PayloadKey.AS_IS);
            } else {
                EntityManager realPC = pc.getPersistenceContext();
                entityManager = emType.getName().equals(Session.class.getName()) ? new ExtendedHibernateSession(isTransient, this.factory, this.container.getInitialContextProperties(), realPC) : new ExtendedEntityManager(isTransient, this.factory, this.container.getInitialContextProperties(), realPC);
            }
        } else {
            entityManager = emType.getName().equals(Session.class.getName()) ? new InjectedHibernateSession(this.factory, this.container.getInitialContextProperties()) : new InjectedEntityManager(this.factory, this.container.getInitialContextProperties());
        }
        return entityManager;
    }
}

