/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;

public class JUnitTest
extends BaseTest
implements Cloneable {
    private String name = null;
    private String outfile = null;
    private long runs;
    private long failures;
    private long errors;
    private long runTime;
    private Properties props = null;

    public JUnitTest() {
    }

    public JUnitTest(String name) {
        this.name = name;
    }

    public JUnitTest(String name, boolean haltOnError, boolean haltOnFailure, boolean filtertrace) {
        this.name = name;
        this.haltOnError = haltOnError;
        this.haltOnFail = haltOnFailure;
        this.filtertrace = filtertrace;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setOutfile(String value) {
        this.outfile = value;
    }

    public String getName() {
        return this.name;
    }

    public String getOutfile() {
        return this.outfile;
    }

    public void setCounts(long runs, long failures, long errors) {
        this.runs = runs;
        this.failures = failures;
        this.errors = errors;
    }

    public void setRunTime(long runTime) {
        this.runTime = runTime;
    }

    public long runCount() {
        return this.runs;
    }

    public long failureCount() {
        return this.failures;
    }

    public long errorCount() {
        return this.errors;
    }

    public long getRunTime() {
        return this.runTime;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Hashtable p) {
        this.props = new Properties();
        Enumeration enumeration = p.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            this.props.put(key, p.get(key));
        }
    }

    public boolean shouldRun(Project p) {
        if (this.ifProperty != null && p.getProperty(this.ifProperty) == null) {
            return false;
        }
        return this.unlessProperty == null || p.getProperty(this.unlessProperty) == null;
    }

    public FormatterElement[] getFormatters() {
        Object[] fes = new FormatterElement[this.formatters.size()];
        this.formatters.copyInto(fes);
        return fes;
    }

    void addFormattersTo(Vector v) {
        int count = this.formatters.size();
        int i = 0;
        while (i < count) {
            v.addElement(this.formatters.elementAt(i));
            ++i;
        }
    }

    public Object clone() {
        try {
            JUnitTest t = (JUnitTest)super.clone();
            t.props = this.props == null ? null : (Properties)this.props.clone();
            t.formatters = (Vector)this.formatters.clone();
            return t;
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }
}

