/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Promise;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class STREAMING_STATE_TRANSFER
extends Protocol {
    private Address local_addr = null;
    private final Vector members = new Vector();
    private final Map state_requesters = new HashMap();
    private Digest digest = null;
    private final HashMap map = new HashMap();
    private int num_state_reqs = 0;
    private long num_bytes_sent = 0L;
    private double avg_state_size = 0.0;
    private static final String NAME = "STREAMING_STATE_TRANSFER";
    private InetAddress bind_addr;
    private int bind_port = 0;
    private StateProviderThreadSpawner spawner;
    private int max_pool = 5;
    private long pool_thread_keep_alive;
    private int socket_buffer_size = 8192;
    private boolean use_reading_thread;
    private final Promise flush_promise = new Promise();
    private volatile boolean use_flush;
    private long flush_timeout = 4000L;
    private final Object poolLock = new Object();
    private int threadCounter;
    private volatile boolean flushProtocolInStack = false;
    static /* synthetic */ Class class$org$jgroups$protocols$pbcast$Digest;
    static /* synthetic */ Class class$org$jgroups$stack$IpAddress;

    public final String getName() {
        return NAME;
    }

    public int getNumberOfStateRequests() {
        return this.num_state_reqs;
    }

    public long getNumberOfStateBytesSent() {
        return this.num_bytes_sent;
    }

    public double getAverageStateSize() {
        return this.avg_state_size;
    }

    public Vector requiredDownServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(42));
        retval.addElement(new Integer(41));
        return retval;
    }

    public void resetStats() {
        super.resetStats();
        this.num_state_reqs = 0;
        this.num_bytes_sent = 0L;
        this.avg_state_size = 0.0;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        this.use_flush = Util.parseBoolean(props, "use_flush", false);
        this.flush_timeout = Util.parseLong(props, "flush_timeout", this.flush_timeout);
        try {
            this.bind_addr = Util.parseBindAddress(props, "bind_addr");
        }
        catch (UnknownHostException e) {
            this.log.error((Object)("(bind_addr): host " + e.getLocalizedMessage() + " not known"));
            return false;
        }
        this.bind_port = Util.parseInt(props, "start_port", 0);
        this.socket_buffer_size = Util.parseInt(props, "socket_buffer_size", 8192);
        this.max_pool = Util.parseInt(props, "max_pool", 5);
        this.pool_thread_keep_alive = Util.parseLong(props, "pool_thread_keep_alive", 30000L);
        this.use_reading_thread = Util.parseBoolean(props, "use_reading_thread", false);
        if (props.size() > 0) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        this.map.put("state_transfer", Boolean.TRUE);
        this.map.put("protocol_class", this.getClass().getName());
    }

    public void start() throws Exception {
        this.passUp(new Event(56, this.map));
        if (!this.flushProtocolInStack && this.use_flush) {
            this.log.warn((Object)"use_flush is true, however, FLUSH protocol not found in stack.");
            this.use_flush = false;
        }
    }

    public void stop() {
        super.stop();
        if (this.spawner != null) {
            this.spawner.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 16: {
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 43: {
                Map map = this.state_requesters;
                synchronized (map) {
                    this.digest = (Digest)evt.getArg();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("GET_DIGEST_STATE_OK: digest is " + this.digest));
                    }
                }
                this.respondToStateRequester();
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                StateHeader hdr = (StateHeader)msg.removeHeader(this.getName());
                if (hdr == null) break;
                switch (hdr.type) {
                    case 1: {
                        this.handleStateReq(hdr);
                        break;
                    }
                    case 2: {
                        this.handleStateRsp(hdr);
                        break;
                    }
                    case 3: {
                        this.removeFromStateRequesters(hdr.sender, hdr.state_id);
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error((Object)("type " + hdr.type + " not known in StateHeader"));
                    }
                }
                return;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (this.bind_addr != null || config == null || !config.containsKey("bind_addr")) break;
                this.bind_addr = (InetAddress)config.get("bind_addr");
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)("using bind_addr from CONFIG event " + this.bind_addr));
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 19: {
                Address target;
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                if (info.target == null) {
                    target = this.determineCoordinator();
                } else {
                    target = info.target;
                    if (target.equals(this.local_addr)) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)"GET_STATE: cannot fetch state from myself !");
                        }
                        target = null;
                    }
                }
                if (target == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"GET_STATE: first member (no state)");
                    }
                    this.passUp(new Event(20, new StateTransferInfo()));
                } else {
                    String stateRequested;
                    boolean successfulFlush = false;
                    if (this.use_flush) {
                        successfulFlush = this.startFlush(this.flush_timeout, 5);
                    }
                    if (successfulFlush) {
                        this.log.debug((Object)("Successful flush at " + this.local_addr));
                    }
                    Message state_req = new Message(target, null, null);
                    state_req.putHeader(NAME, new StateHeader(1, this.local_addr, info.state_id));
                    String string = stateRequested = info.state_id == null ? "full" : info.state_id;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Member " + this.local_addr + " asking " + target + " for " + stateRequested + " state"));
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)"passing down a SUSPEND_STABLE event");
                    }
                    this.passDown(new Event(65, new Long(info.timeout)));
                    this.passDown(new Event(1, state_req));
                }
                return;
            }
            case 73: {
                if (this.use_flush) {
                    this.stopFlush();
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"STATE_TRANSFER_INPUTSTREAM_CLOSED received");
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"passing down a RESUME_STABLE event");
                }
                this.passDown(new Event(66));
                return;
            }
            case 69: {
                if (!this.use_flush) break;
                this.flush_promise.setResult(Boolean.TRUE);
                break;
            }
            case 76: {
                if (!this.use_flush) break;
                this.flush_promise.setResult(Boolean.FALSE);
                break;
            }
            case 56: {
                Map config = (Map)evt.getArg();
                if (config != null && config.containsKey("flush_timeout")) {
                    Long ftimeout = (Long)config.get("flush_timeout");
                    this.use_flush = true;
                    this.flush_timeout = ftimeout;
                }
                if (config == null || config.containsKey("flush_suported")) break;
                this.flushProtocolInStack = true;
            }
        }
        this.passDown(evt);
    }

    private boolean isDigestNeeded() {
        return !this.use_flush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void respondToStateRequester() {
        if (this.spawner == null) {
            ServerSocket serverSocket = Util.createServerSocket(this.bind_addr, this.bind_port);
            this.spawner = new StateProviderThreadSpawner(this.setupThreadPool(), serverSocket);
            new Thread(Util.getGlobalThreadGroup(), this.spawner, "StateProviderThreadSpawner").start();
        }
        Map map = this.state_requesters;
        synchronized (map) {
            if (this.state_requesters.isEmpty()) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"Should be responding to state requester, but there are no requesters !");
                }
                return;
            }
            if (this.digest == null && this.isDigestNeeded()) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"Should be responding to state requester, but there is no digest !");
                }
            } else if (this.digest != null && this.isDigestNeeded()) {
                this.digest = this.digest.copy();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Iterating state requesters " + this.state_requesters));
            }
            Iterator it = this.state_requesters.keySet().iterator();
            while (it.hasNext()) {
                String tmp_state_id = (String)it.next();
                Set requesters = (Set)this.state_requesters.get(tmp_state_id);
                Iterator iter = requesters.iterator();
                while (iter.hasNext()) {
                    Address requester = (Address)iter.next();
                    Message state_rsp = new Message(requester);
                    StateHeader hdr = new StateHeader(2, this.local_addr, this.spawner.getServerSocketAddress(), this.isDigestNeeded() ? this.digest : null, tmp_state_id);
                    state_rsp.putHeader(NAME, hdr);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Responding to state requester " + requester + " with address " + this.spawner.getServerSocketAddress() + " and digest " + this.digest));
                    }
                    this.passDown(new Event(1, state_rsp));
                    if (!this.stats) continue;
                    ++this.num_state_reqs;
                }
            }
        }
    }

    private boolean startFlush(long timeout, int numberOfAttempts) {
        boolean successfulFlush = false;
        this.flush_promise.reset();
        this.passUp(new Event(68));
        try {
            Boolean r = (Boolean)this.flush_promise.getResultWithTimeout(timeout);
            successfulFlush = r;
        }
        catch (TimeoutException e) {
            this.log.warn((Object)("Initiator of flush and state requesting member " + this.local_addr + " timed out waiting for flush responses after " + this.flush_timeout + " msec"));
        }
        if (!successfulFlush && numberOfAttempts > 0) {
            long backOffSleepTime = Util.random(5000L);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Flush in progress detected at " + this.local_addr + ". Backing off for " + backOffSleepTime + " ms. Attempts left " + numberOfAttempts));
            }
            Util.sleepRandom(backOffSleepTime);
            successfulFlush = this.startFlush(this.flush_timeout, --numberOfAttempts);
        }
        return successfulFlush;
    }

    private void stopFlush() {
        this.passUp(new Event(70));
    }

    private PooledExecutor setupThreadPool() {
        PooledExecutor threadPool = new PooledExecutor(this.max_pool);
        threadPool.waitWhenBlocked();
        threadPool.setMinimumPoolSize(1);
        threadPool.setKeepAliveTime(this.pool_thread_keep_alive);
        threadPool.setThreadFactory(new ThreadFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Thread newThread(final Runnable command) {
                Object object = STREAMING_STATE_TRANSFER.this.poolLock;
                synchronized (object) {
                    STREAMING_STATE_TRANSFER.this.threadCounter++;
                }
                return new Thread(Util.getGlobalThreadGroup(), "STREAMING_STATE_TRANSFER.poolid=" + STREAMING_STATE_TRANSFER.this.threadCounter){

                    public void run() {
                        if (STREAMING_STATE_TRANSFER.this.log.isTraceEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.trace((Object)(Thread.currentThread() + " started."));
                        }
                        command.run();
                        if (STREAMING_STATE_TRANSFER.this.log.isTraceEnabled()) {
                            STREAMING_STATE_TRANSFER.this.log.trace((Object)(Thread.currentThread() + " stopped."));
                        }
                    }
                };
            }
        });
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Address determineCoordinator() {
        Address ret = null;
        Vector vector = this.members;
        synchronized (vector) {
            if (!this.members.isEmpty()) {
                for (int i = 0; i < this.members.size(); ++i) {
                    if (this.local_addr.equals(this.members.elementAt(i))) continue;
                    return (Address)this.members.elementAt(i);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewChange(View v) {
        Vector vector = this.members;
        synchronized (vector) {
            this.members.clear();
            this.members.addAll(v.getMembers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStateReq(StateHeader hdr) {
        Address sender = hdr.sender;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender is null !");
            }
            return;
        }
        String id = hdr.state_id;
        Map map = this.state_requesters;
        synchronized (map) {
            boolean empty = this.state_requesters.isEmpty();
            HashSet<Address> requesters = (HashSet<Address>)this.state_requesters.get(id);
            if (requesters == null) {
                requesters = new HashSet<Address>();
            }
            requesters.add(sender);
            this.state_requesters.put(id, requesters);
            if (!this.isDigestNeeded()) {
                this.respondToStateRequester();
            } else if (empty) {
                this.digest = null;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"passing down GET_DIGEST_STATE");
                }
                this.passDown(new Event(42));
            }
        }
    }

    void handleStateRsp(StateHeader hdr) {
        Digest tmp_digest = hdr.my_digest;
        if (this.isDigestNeeded()) {
            if (tmp_digest == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)("digest received from " + hdr.sender + " is null, skipping setting digest !"));
                }
            } else {
                this.passDown(new Event(41, tmp_digest));
            }
        }
        this.connectToStateProvider(hdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromStateRequesters(Address address, String state_id) {
        Map map = this.state_requesters;
        synchronized (map) {
            Set requesters = (Set)this.state_requesters.get(state_id);
            if (requesters != null && !requesters.isEmpty()) {
                boolean removed = requesters.remove(address);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Attempted to clear " + address + " from requesters, successful=" + removed));
                }
                if (requesters.isEmpty()) {
                    this.state_requesters.remove(state_id);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Cleared all requesters for state " + state_id + ",state_requesters=" + this.state_requesters));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void connectToStateProvider(StateHeader hdr) {
        block24: {
            Socket socket;
            StateTransferInfo sti;
            StreamingInputStreamWrapper wrapper;
            String tmp_state_id;
            block22: {
                IpAddress address = hdr.bind_addr;
                tmp_state_id = hdr.getStateId();
                wrapper = null;
                sti = null;
                socket = new Socket();
                socket.bind(new InetSocketAddress(this.bind_addr, 0));
                int bufferSize = socket.getReceiveBufferSize();
                socket.setReceiveBufferSize(this.socket_buffer_size);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Connecting to state provider " + address.getIpAddress() + ":" + address.getPort() + ", original buffer size was " + bufferSize + " and was reset to " + socket.getReceiveBufferSize()));
                }
                socket.connect(new InetSocketAddress(address.getIpAddress(), address.getPort()));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Connected to state provider, my end of the socket is " + socket.getLocalAddress() + ":" + socket.getLocalPort() + " passing inputstream up..."));
                }
                ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
                out.writeObject(tmp_state_id);
                out.writeObject(this.local_addr);
                wrapper = new StreamingInputStreamWrapper(socket);
                sti = new StateTransferInfo(hdr.sender, wrapper, tmp_state_id);
                Object var10_11 = null;
                if (socket.isConnected()) break block22;
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"Could not connect to state provider. Closing socket...");
                }
                try {
                    if (wrapper != null) {
                        wrapper.close();
                    } else {
                        socket.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                Message m = new Message(hdr.sender);
                StateHeader mhdr = new StateHeader(3, this.local_addr, tmp_state_id);
                m.putHeader(NAME, mhdr);
                this.passDown(new Event(1, m));
            }
            this.passStreamUp(sti);
            {
                break block24;
                catch (IOException e) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)"State reader socket thread spawned abnormaly", (Throwable)e);
                    }
                    InputStream is = null;
                    sti = new StateTransferInfo(hdr.sender, is, tmp_state_id);
                    Object var10_12 = null;
                    if (!socket.isConnected()) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)"Could not connect to state provider. Closing socket...");
                        }
                        try {
                            if (wrapper != null) {
                                wrapper.close();
                            } else {
                                socket.close();
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        Message m = new Message(hdr.sender);
                        StateHeader mhdr = new StateHeader(3, this.local_addr, tmp_state_id);
                        m.putHeader(NAME, mhdr);
                        this.passDown(new Event(1, m));
                    }
                    this.passStreamUp(sti);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (!socket.isConnected()) {
                    if (this.log.isWarnEnabled()) {
                        this.log.warn((Object)"Could not connect to state provider. Closing socket...");
                    }
                    try {
                        if (wrapper != null) {
                            wrapper.close();
                        } else {
                            socket.close();
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    Message m = new Message(hdr.sender);
                    StateHeader mhdr = new StateHeader(3, this.local_addr, tmp_state_id);
                    m.putHeader(NAME, mhdr);
                    this.passDown(new Event(1, m));
                }
                this.passStreamUp(sti);
                throw throwable;
            }
        }
    }

    private void passStreamUp(final StateTransferInfo sti) {
        Runnable readingThread = new Runnable(){

            public void run() {
                STREAMING_STATE_TRANSFER.this.passUp(new Event(71, sti));
            }
        };
        if (this.use_reading_thread) {
            new Thread(Util.getGlobalThreadGroup(), readingThread, "STREAMING_STATE_TRANSFER.reader").start();
        } else {
            readingThread.run();
        }
    }

    public static class StateHeader
    extends Header
    implements Streamable {
        public static final byte STATE_REQ = 1;
        public static final byte STATE_RSP = 2;
        public static final byte STATE_REMOVE_REQUESTER = 3;
        long id = 0L;
        byte type = 0;
        Address sender;
        Digest my_digest = null;
        IpAddress bind_addr = null;
        String state_id = null;

        public StateHeader() {
        }

        public StateHeader(byte type, Address sender, String state_id) {
            this.type = type;
            this.sender = sender;
            this.state_id = state_id;
        }

        public StateHeader(byte type, Address sender, long id, Digest digest) {
            this.type = type;
            this.sender = sender;
            this.id = id;
            this.my_digest = digest;
        }

        public StateHeader(byte type, Address sender, IpAddress bind_addr, Digest digest, String state_id) {
            this.type = type;
            this.sender = sender;
            this.my_digest = digest;
            this.bind_addr = bind_addr;
            this.state_id = state_id;
        }

        public int getType() {
            return this.type;
        }

        public Digest getDigest() {
            return this.my_digest;
        }

        public String getStateId() {
            return this.state_id;
        }

        public boolean equals(Object o) {
            if (this.sender != null && o != null) {
                if (!(o instanceof StateHeader)) {
                    return false;
                }
                StateHeader other = (StateHeader)o;
                return this.sender.equals(other.sender) && this.id == other.id;
            }
            return false;
        }

        public int hashCode() {
            if (this.sender != null) {
                return this.sender.hashCode() + (int)this.id;
            }
            return (int)this.id;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("type=").append(StateHeader.type2Str(this.type));
            if (this.sender != null) {
                sb.append(", sender=").append(this.sender).append(" id=").append(this.id);
            }
            if (this.my_digest != null) {
                sb.append(", digest=").append(this.my_digest);
            }
            return sb.toString();
        }

        static String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "STATE_REQ";
                }
                case 2: {
                    return "STATE_RSP";
                }
                case 3: {
                    return "STATE_REMOVE_REQUESTER";
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.sender);
            out.writeLong(this.id);
            out.writeByte(this.type);
            out.writeObject(this.my_digest);
            out.writeObject(this.bind_addr);
            out.writeUTF(this.state_id);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.sender = (Address)in.readObject();
            this.id = in.readLong();
            this.type = in.readByte();
            this.my_digest = (Digest)in.readObject();
            this.bind_addr = (IpAddress)in.readObject();
            this.state_id = in.readUTF();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            out.writeLong(this.id);
            Util.writeAddress(this.sender, out);
            Util.writeStreamable(this.my_digest, out);
            Util.writeStreamable(this.bind_addr, out);
            Util.writeString(this.state_id, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.id = in.readLong();
            this.sender = Util.readAddress(in);
            this.my_digest = (Digest)Util.readStreamable(class$org$jgroups$protocols$pbcast$Digest == null ? (class$org$jgroups$protocols$pbcast$Digest = STREAMING_STATE_TRANSFER.class$("org.jgroups.protocols.pbcast.Digest")) : class$org$jgroups$protocols$pbcast$Digest, in);
            this.bind_addr = (IpAddress)Util.readStreamable(class$org$jgroups$stack$IpAddress == null ? (class$org$jgroups$stack$IpAddress = STREAMING_STATE_TRANSFER.class$("org.jgroups.stack.IpAddress")) : class$org$jgroups$stack$IpAddress, in);
            this.state_id = Util.readString(in);
        }

        public long size() {
            long retval = 9L;
            retval += (long)Util.size(this.sender);
            ++retval;
            if (this.my_digest != null) {
                retval += this.my_digest.serializedSize();
            }
            ++retval;
            if (this.state_id != null) {
                retval += (long)(this.state_id.length() + 2);
            }
            return retval;
        }
    }

    private class StreamingOutputStreamWrapper
    extends OutputStream {
        private Socket outputStreamOwner;
        private OutputStream delegate;
        private long bytesWrittenCounter = 0L;
        private Channel channelOwner;

        public StreamingOutputStreamWrapper(Socket outputStreamOwner) throws IOException {
            this.outputStreamOwner = outputStreamOwner;
            this.delegate = new BufferedOutputStream(outputStreamOwner.getOutputStream());
            this.channelOwner = STREAMING_STATE_TRANSFER.this.stack.getChannel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                STREAMING_STATE_TRANSFER.this.log.debug((Object)("State writer " + this.outputStreamOwner + " is closing the socket "));
            }
            try {
                if (this.channelOwner != null && this.channelOwner.isConnected()) {
                    this.channelOwner.down(new Event(74));
                }
                this.outputStreamOwner.close();
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (STREAMING_STATE_TRANSFER.this.stats) {
                    Map map = STREAMING_STATE_TRANSFER.this.state_requesters;
                    synchronized (map) {
                        STREAMING_STATE_TRANSFER.this.num_bytes_sent += this.bytesWrittenCounter;
                        STREAMING_STATE_TRANSFER.this.avg_state_size = (double)STREAMING_STATE_TRANSFER.this.num_bytes_sent / (double)STREAMING_STATE_TRANSFER.this.num_state_reqs;
                    }
                }
            }
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
            this.bytesWrittenCounter += (long)len;
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
            if (b != null) {
                this.bytesWrittenCounter += (long)b.length;
            }
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
            ++this.bytesWrittenCounter;
        }
    }

    private class StreamingInputStreamWrapper
    extends InputStream {
        private Socket inputStreamOwner;
        private InputStream delegate;
        private Channel channelOwner;

        public StreamingInputStreamWrapper(Socket inputStreamOwner) throws IOException {
            this.inputStreamOwner = inputStreamOwner;
            this.delegate = new BufferedInputStream(inputStreamOwner.getInputStream());
            this.channelOwner = STREAMING_STATE_TRANSFER.this.stack.getChannel();
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void close() throws IOException {
            if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                STREAMING_STATE_TRANSFER.this.log.debug((Object)("State reader " + this.inputStreamOwner + " is closing the socket "));
            }
            if (this.channelOwner != null && this.channelOwner.isConnected()) {
                this.channelOwner.down(new Event(73));
            }
            this.inputStreamOwner.close();
        }

        public synchronized void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public synchronized void reset() throws IOException {
            this.delegate.reset();
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }
    }

    private class StateProviderHandler {
        private StateProviderHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Socket socket) {
            StreamingOutputStreamWrapper wrapper = null;
            ObjectInputStream ois = null;
            try {
                int bufferSize = socket.getSendBufferSize();
                socket.setSendBufferSize(STREAMING_STATE_TRANSFER.this.socket_buffer_size);
                if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                    STREAMING_STATE_TRANSFER.this.log.debug((Object)("Running on " + Thread.currentThread() + ". Accepted request for state transfer from " + socket.getInetAddress() + ":" + socket.getPort() + ", original buffer size was " + bufferSize + " and was reset to " + socket.getSendBufferSize() + ", passing outputstream up... "));
                }
                ois = new ObjectInputStream(socket.getInputStream());
                String state_id = (String)ois.readObject();
                Address stateRequester = (Address)ois.readObject();
                STREAMING_STATE_TRANSFER.this.removeFromStateRequesters(stateRequester, state_id);
                wrapper = new StreamingOutputStreamWrapper(socket);
                StateTransferInfo sti = new StateTransferInfo(stateRequester, wrapper, state_id);
                STREAMING_STATE_TRANSFER.this.passUp(new Event(72, sti));
            }
            catch (IOException e) {
                if (STREAMING_STATE_TRANSFER.this.log.isWarnEnabled()) {
                    STREAMING_STATE_TRANSFER.this.log.warn((Object)"State writer socket thread spawned abnormaly", (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
            }
            finally {
                if (socket != null && !socket.isConnected()) {
                    if (STREAMING_STATE_TRANSFER.this.log.isWarnEnabled()) {
                        STREAMING_STATE_TRANSFER.this.log.warn((Object)("Accepted request for state transfer but socket " + socket + " not connected properly. Closing it..."));
                    }
                    try {
                        if (wrapper != null) {
                            wrapper.close();
                        } else {
                            socket.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private class StateProviderThreadSpawner
    implements Runnable {
        PooledExecutor pool;
        ServerSocket serverSocket;
        IpAddress address;
        Thread runner;
        volatile boolean running = true;

        public StateProviderThreadSpawner(PooledExecutor pool, ServerSocket stateServingSocket) {
            if (pool == null || stateServingSocket == null) {
                throw new IllegalArgumentException("Cannot create thread pool");
            }
            this.pool = pool;
            this.serverSocket = stateServingSocket;
            this.address = new IpAddress(STREAMING_STATE_TRANSFER.this.bind_addr, this.serverSocket.getLocalPort());
        }

        public void run() {
            this.runner = Thread.currentThread();
            while (this.running) {
                try {
                    if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                        STREAMING_STATE_TRANSFER.this.log.debug((Object)("StateProviderThreadSpawner listening at " + this.getServerSocketAddress() + "..."));
                    }
                    if (STREAMING_STATE_TRANSFER.this.log.isTraceEnabled()) {
                        STREAMING_STATE_TRANSFER.this.log.trace((Object)("Pool has " + this.pool.getPoolSize() + " active threads"));
                    }
                    final Socket socket = this.serverSocket.accept();
                    this.pool.execute(new Runnable(){

                        public void run() {
                            if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                                STREAMING_STATE_TRANSFER.this.log.debug((Object)("Accepted request for state transfer from " + socket.getInetAddress() + ":" + socket.getPort() + " handing of to PooledExecutor thread"));
                            }
                            new StateProviderHandler().process(socket);
                        }
                    });
                }
                catch (IOException e) {
                    if (!STREAMING_STATE_TRANSFER.this.log.isWarnEnabled() || this.serverSocket.isClosed()) continue;
                    STREAMING_STATE_TRANSFER.this.log.warn((Object)"Spawning socket from server socket finished abnormaly", (Throwable)e);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public IpAddress getServerSocketAddress() {
            return this.address;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.running = false;
            try {
                if (!this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                }
            }
            catch (IOException e) {
            }
            finally {
                if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                    STREAMING_STATE_TRANSFER.this.log.debug((Object)"Waiting for StateProviderThreadSpawner to die ... ");
                }
                try {
                    this.runner.join(3000L);
                }
                catch (InterruptedException ignored) {}
                if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                    STREAMING_STATE_TRANSFER.this.log.debug((Object)"Shutting the thread pool down... ");
                }
                this.pool.shutdownNow();
                try {
                    this.pool.awaitTerminationAfterShutdown(5000L);
                }
                catch (InterruptedException ignored) {}
            }
            if (STREAMING_STATE_TRANSFER.this.log.isDebugEnabled()) {
                STREAMING_STATE_TRANSFER.this.log.debug((Object)"Thread pool is shutdown. All pool threads are cleaned up.");
            }
        }
    }
}

