/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.lang.reflect.Method;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import org.jboss.mx.util.ProxyContext;
import org.jboss.mx.util.ProxyExceptionHandler;
import org.jboss.mx.util.RuntimeProxyException;

public class DefaultExceptionHandler
implements ProxyExceptionHandler {
    public Object handleInstanceNotFound(ProxyContext ctx, InstanceNotFoundException e, Method m, Object[] args) throws Exception {
        throw new RuntimeProxyException("Instance not found: " + e.toString());
    }

    public Object handleAttributeNotFound(ProxyContext ctx, AttributeNotFoundException e, Method m, Object[] args) throws Exception {
        throw new RuntimeProxyException("Attribute not found: " + e.toString());
    }

    public Object handleInvalidAttributeValue(ProxyContext ctx, InvalidAttributeValueException e, Method m, Object[] args) throws Exception {
        throw new RuntimeProxyException("Invalid attribute value: " + e.toString());
    }

    public Object handleMBeanException(ProxyContext ctx, MBeanException e, Method m, Object[] args) throws Exception {
        throw e.getTargetException();
    }

    public Object handleReflectionException(ProxyContext ctx, ReflectionException e, Method m, Object[] args) throws Exception {
        Exception target = e.getTargetException();
        if (target instanceof RuntimeException) {
            throw target;
        }
        throw new RuntimeProxyException(target.toString());
    }

    public Object handleRuntimeOperationsException(ProxyContext ctx, RuntimeOperationsException e, Method m, Object[] args) throws Exception {
        throw e.getTargetException();
    }

    public Object handleRuntimeMBeanException(ProxyContext ctx, RuntimeMBeanException e, Method m, Object[] args) throws Exception {
        throw e.getTargetException();
    }

    public Object handleRuntimeError(ProxyContext ctx, RuntimeErrorException e, Method m, Object[] args) throws Exception {
        throw e.getTargetError();
    }
}

