/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.velocity;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class URLBean {
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private String page = null;
    private Map params = null;

    public String getPage() {
        return this.page;
    }

    public URLBean setPage(String page) {
        this.page = page;
        return this;
    }

    public URLBean addParameter(String name, Object value) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        if (value == null) {
            this.params.remove(name);
        } else {
            this.params.put(name, value.toString());
        }
        return this;
    }

    public void setRequest(HttpServletRequest req) {
        this.request = req;
    }

    public void setResponse(HttpServletResponse resp) {
        this.response = resp;
    }

    public String getURL() {
        String result;
        if (this.page == null) {
            this.params = this.request.getParameterMap();
        }
        StringBuffer link = new StringBuffer();
        if (this.page != null) {
            if (this.page.startsWith("/")) {
                String appContext = this.request.getContextPath();
                link.append(appContext);
            }
            link.append(this.page);
        } else {
            String requestURI = (String)this.request.getAttribute("webwork.request_uri");
            if (requestURI == null) {
                requestURI = this.request.getRequestURI();
            }
            link.append(requestURI);
        }
        if (this.params != null && this.params.size() > 0) {
            link.append('?');
            Iterator iterator = this.params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value != null) {
                    if (value instanceof String) {
                        link.append(name);
                        link.append('=');
                        link.append(URLEncoder.encode((String)value));
                    } else {
                        String[] values = (String[])value;
                        link.append(name);
                        link.append('=');
                        link.append(URLEncoder.encode(values[0]));
                    }
                }
                if (!iterator.hasNext()) continue;
                link.append("&amp;");
            }
        }
        try {
            result = this.response.encodeURL(link.toString());
        }
        catch (Exception e) {
            result = link.toString();
        }
        this.params = null;
        this.page = null;
        return result;
    }

    public String toString() {
        return this.getURL();
    }
}

